# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from Ark import ReversibleDict
from TunnelTypeLib import tunnelTypeStrDict

showTunnelFibIgnoredTunnelTypes = set( [
   'bgpLuPushTunnel',
   'staticInterfaceTunnel',
] )

# Convert tunnel type strings to CLI tokens
# i.e. 'Static IPv6' to static-ipv6, 'IS IS SR IPv4' to sr-ipv4
def getTunnelTypeTokens():
   tokens = {}
   xlate = {}
   for t, v in tunnelTypeStrDict.iteritems():
      if t not in showTunnelFibIgnoredTunnelTypes:
         key = v.lower().replace( " ", "-" ).replace( "is-is-", "" )
         xlate[ key ] = t
         tokens[ key ] = 'Match %s tunnel type' % v

   return tokens, xlate

( tunnelTypes, tunnelTypeXlate ) = getTunnelTypeTokens()

tunnelTypeRevXlate = ReversibleDict( tunnelTypeXlate ).reverse()
