# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from TypeFuture import TacLazyType

from ClientCommonLib import ( lspPingRetCodeStr, LspPingReturnCode )

Ipv4Numbered = Tac.Type( 'LspPing::LspPingAddrType' ).ipv4Numbered
Ipv6Numbered = Tac.Type( 'LspPing::LspPingAddrType' ).ipv6Numbered
ConnectorKey = Tac.Type( 'Pseudowire::ConnectorKey' )
DynTunnelIntfId = Tac.Type( 'Arnet::DynamicTunnelIntfId' )
LspPingDownstreamMappingType = TacLazyType(
      'LspPing::LspPingDownstreamMappingType' )
LspPingReturnCode = Tac.Type( 'LspPing::LspPingReturnCode' )

# ---------------------------------------------------------
#           Traceroute render helpers
# ---------------------------------------------------------

def tracerouteReplyHdrRender( hopPktInfo ):
   if hopPktInfo.replyHost:
      output = '{:>3}  '.format( hopPktInfo.ttl )
      output += '{:<16}  '.format( hopPktInfo.replyHost )

      if int( hopPktInfo.hopMtu ) > 0:
         output += 'MTU {:<4}  '.format( hopPktInfo.hopMtu )

      output += '{:<8}'.format( str( hopPktInfo.roundTrip ) + 'ms' )

      if hopPktInfo.retCode == LspPingReturnCode.seeDdmTlv:
         output += '  return code: {}'.format( lspPingRetCodeStr(
                                            hopPktInfo.retCode ) )
      elif hopPktInfo.retCode != LspPingReturnCode.noRetCode:
         if ( hopPktInfo.retCode == LspPingReturnCode.labelSwitchedAtStackDep or
              hopPktInfo.retCode == LspPingReturnCode.repRouterEgress ):
            output += '  success: '
         else:
            output += '  error: '
         output += lspPingRetCodeStr( hopPktInfo.retCode )
      print output
   else:
      print '{:>3} ***'.format( hopPktInfo.ttl )

def tracerouteDownstreamInfoRender( downstreamInfos ):
   for index, dsInfo in enumerate( downstreamInfos ):
      if dsInfo.dsType == str( LspPingDownstreamMappingType.downstreamMap ):
         print '     downstream information (DSMAP) ' + str( index + 1 ) + ':'
      else:
         retCode = lspPingRetCodeStr( dsInfo.retCode )
         print '     downstream information (DDMAP) ' + str( index + 1 ) + ':'
         print '        return code: {}'.format( retCode )
      if ( dsInfo.addrType == Ipv4Numbered or dsInfo.addrType == Ipv6Numbered ):
         print '        interface address: {}'.format( dsInfo.dsIntfAddr )
      else:
         print '        interface index: {}'.format( dsInfo.dsIntfIndex )
      print '        IP address: {}'.format( dsInfo.dsIpAddr )
      labelStackStr = ( ', '.join( dsInfo.labelStack ) )
      print '        label stack: [{}]'.format( labelStackStr )

def tracerouteLabelStackRender( labelStackInfo ):
   labelStackStr = ( ', '.join( labelStackInfo.labelStack ) )
   print '     label stack: [{}]'.format( labelStackStr )
