# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#from __future__ import absolute_import, division, print_function

import re

def printTable( f, obj ):
   if not obj:
      return
   headings1 = obj[ 0 ].keys()
   headings2 = None
   widths = []
   for o in obj.toks:
      if not o[ 2 ]:
         widths.append( len( o[ 1 ] ) )
      else:
         m = re.search( r'\d+', o[ 2 ] )
         widths.append( int( m.group() ) )
   line = [ '-' * i for i in widths ]
   for i, name in enumerate( headings1 ):
      name = headings1[ i ]
      width = len( name )
      if width > widths[ i ]:
         if '_' in name:
            toks = name.split( '_' )
            headings1[ i ] = toks[ 1 ]
            if not headings2:
               headings2 = [ '' ] * len( headings1 )
            headings2[ i ] = toks[ 0 ]
         else:
            headings1[ i ] = name[ 0 : widths[ i ] ]
      else:
         headings1[ i ] = headings1[ i ].replace( '_', ' ' )

   if headings2:
      print >>f, obj.format( **dict( zip( obj[ 0 ].keys(), headings2 ) ) )
   print >>f, obj.format( **dict( zip( obj[ 0 ].keys(), headings1 ) ) )
   print >>f, obj.format( **dict( zip( obj[ 0 ].keys(), line ) ) )
   for row in obj:
      print >>f, obj.format( **row )

def printFlattened( f, obj, max_columns=None, indent=0 ):
   space = ' ' * indent
   for e in obj:
      line = space
      columns = 0
      for k, v in e.items():
         if k not in [ 'Port', 'Name' ]:
            columns += 1
            if max_columns:
               if columns > max_columns:
                  print >>f, line
                  line = space
                  columns = 0
            line += ' %s: %s' % ( k, v )
      print >>f, line

def printDict( f, d, indent=0 ):
   space = ' ' * indent
   for k, v in d.items():
      if isinstance( v, dict ):
         nested = v.pop( 'Nested', None )
         if nested and len( v.keys() ) == 1:
            print >>f, '{}{}: {}'.format( space, k, v.keys()[ 0 ] )
            v = v.values()[ 0 ]
            if isinstance( v, list ):
               print >>f
               printTable( f, v )
               print >>f
               continue
         else:
            print >>f, '{}{}:'.format( space, k )
         printDict( f, v, indent + 4 )
         print >>f

      elif isinstance( v, list ):
         if all( isinstance( e, dict ) for e in v ):
            print >>f, '{}{}:\n'.format( space, k )
            printTable( f, v )
         else:
            print >>f, ( '{}{}'.format( space, k ) ),
            printObject( f, v )
      else:
         print >>f, '{}{}: {}'.format( space, k, v )

def printObject( f, obj, max_columns=None, flattened=None ):
   if isinstance( obj, list ):
      if all( isinstance( e, dict ) for e in obj ):
         if flattened:
            printFlattened( f, obj, max_columns )
         else:
            printTable( f, obj )
      else:
         for i, item in enumerate( obj ):
            if i > 0:
               if not flattened:
                  print >>f
            printObject( f, item, max_columns, flattened )
   elif isinstance( obj, dict ):
      printDict( f, obj )
   elif hasattr( obj, '__iter__' ):
      for it in obj:
         printObject( f, it, max_columns, flattened )
   else:
      s = str( obj )
      if not s.endswith( '\n' ):
         s += '\n'
      f.write( s )
