#!/usr/bin/env python
# Copyright (c) 2009-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BothTrace
import Tac

BothTrace.initialize( 'qt-out-%d.qt' )
bv = BothTrace.Var
bt2 = BothTrace.trace2

# subdirDeprecated collection is being deprecated from EOS.
# To be compatible with past/future releases, follow these
# recommendations:
# Do not introduce any new calls to newSubdirDeprecated
# i.e call newEntity to create an entity
# rather than a subdir.
# If looking up a subdir, first look in entityPtr collection
# if the key is not found, look in subdirDeprecated collection
# See AID/7616 for more details

def Plugin( ctx ):
   agent = ctx.agent

   # Create p2p entities for export.
   # subdirDeprecated collection is being deprecated from EOS.
   # do not introduce new calls to newSubdirDeprecated,
   # use newEntity to create an entity instead.
   # see message on top of this file regarding subdirDeprecated
   # lookup/creation.
   vlanDir = ctx.localDir.newSubdirDeprecated( 'dynvlan' )
   p2pLocalVlans = vlanDir.newEntity( "Bridging::Input::VlanIdSet", "mlag" )

   # Mount local entities from Sysdb
   mg = ctx.entityManager.mountGroup()
   vlansSysdbDir = mg.mount( 'bridging/input/dynvlan/vlan', 'Tac::Dir', 'ri' )
   mlagVlansSysdb = mg.mount( 'bridging/input/peervlan',
                              'Bridging::Input::VlanIdSet', 'w' )

   def peerRoot():
      return ctx.mountStatus.peerRoot

   def activeSupervisor():
      return ctx.agent.runMode == 'mlagActive'

   def handleActive( mlagState, failover ):
      bt2( 'handleActive called with state', bv( mlagState ), 'failover',
          bv( failover ) )
      if not agent.vlanSysdbToP2pSm:
         agent.vlanSysdbToP2pSm = ( vlansSysdbDir, p2pLocalVlans )

      if not activeSupervisor():
         return

      if failover:
         bt2( "Failover: removing VlanP2pToSysdbSm" )
         agent.vlanP2pToSysdbSm = None
         mlagVlansSysdb.vlans = ''
      elif peerRoot():
         if not agent.vlanP2pToSysdbSm:
            bt2( "Creating VlanP2pToSysdbSm" )
            # Try/except in case peer does not support dynamic VLAN sync
            try:
               peerRootDynVlan = None
               # subdirDeprecated collection is being deprecated from EOS.
               # to be compatible with past/future releases 
               # first look up in default collection ( entityPtr )
               # see message on top of this file regarding subdirDeprecated
               # lookup/creation.
               if peerRoot().get( 'dynvlan' ):
                  peerRootDynVlan = peerRoot()['dynvlan']
               else:
                  # lookup in subdirDeprecated collection
                  peerRootDynVlan = peerRoot().subdirDeprecated['dynvlan']
               peerVlans = peerRootDynVlan.entity[ 'mlag' ]
               if peerVlans:
                  agent.vlanP2pToSysdbSm = ( peerVlans, mlagVlansSysdb )
            except KeyError:
               bt2( "Remote end does not support dynamic VLAN sync" )
      else:
         bt2( "No peer root: not creating VlanP2pToSysdbSm" )

   def handleInactive():
      bt2( "Clean up bridging-related state" )
      agent.vlanSysdbToP2pSm = None
      agent.vlanP2pToSysdbSm = None
      if activeSupervisor():
         bt2( "Redundancy mode is active. Clean up Sysdb." )
         mlagVlansSysdb.vlans = ''
         p2pLocalVlans.vlans = ''

   def finishMounts():
      def handleMlagStateForVlan( mlagState, failover ):
         if mlagState in ( 'primary', 'secondary' ):
            handleActive( mlagState, failover )
         else:
            handleInactive()

      mlagVlansSysdb.configPriority = mlagVlansSysdb.configPriorityLow
      mlagVlansSysdb.mlagSync = False
      ctx.callbackIs( handleMlagStateForVlan )

   mg.close( finishMounts )
