#!/usr/bin/env python
# Copyright (c) 2009-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This MlagPlugin handles creating and destroying the reactors that
# manage the Bridging::Topology objects.

from GenericReactor import GenericReactor

import Tracing
t2 = Tracing.trace2

# subdirDeprecated collection is being deprecated from EOS.
# To be compatible with past/future releases, follow these
# recommendations:
# Do not introduce any new calls to newSubdirDeprecated
# i.e call newEntity to create an entity
# rather than a subdir.
# If looking up a subdir, first look in entityPtr collection
# if the key is not found, look in subdirDeprecated collection
# See AID/7616 for more details

def Plugin( ctx ):
   agent = ctx.agent

   # Create local directories to be shared with peer.
   # subdirDeprecated collection is being deprecated from EOS.
   # do not introduce new calls to newSubdirDeprecated,
   # use newEntity to create an entity instead.
   # see message on top of this file regarding subdirDeprecated
   # lookup/creation.
   bridgingDir = ctx.localDir.newSubdirDeprecated( 'bridging' )
   topologyDir = bridgingDir.newSubdirDeprecated( 'topology' )
   lbts = topologyDir.newEntity( "MlagP2p::Bridging::Topology::Status",
                                 "status" )

   # Mount from sysdb.
   mg = ctx.entityManager.mountGroup()
   bti = mg.mount( 'bridging/topology/inst', 'Tac::Dir', 'ri' )
   btc = mg.mount( 'bridging/topology/config', 'Bridging::Topology::Config',
                   'r' )
   btis = mg.mount( 'bridging/topology/peer-inst/mlag',
                    'Bridging::Topology::Inst::Status', 'wc')
   reactors = set()

   def activeSupervisor():
      return ctx.agent.runMode == 'mlagActive'      

   def handleActive( mlagState, failover, btis ):
      if agent.topoStatusSysdbToP2pSm:
         # Already primary or secondary
         if mlagState == 'primary' and agent.topoStatusP2pToSysdbSm:
            t2( "Failover changed. Update peer state." )
            agent.topoStatusP2pToSysdbSm.handleFailover( failover )
      else:
         # Mlag shares its local topo port state with its peer.
         # Currently it arbitrarily picks one, replacing it if it goes
         # away (e.g., if a linecard is removed). Eventually we want
         # to merge all of the local topo port states (BUG35469).
         def handleTopoInst( dummy=None, key=None ):
            if agent.topoStatusSysdbToP2pSm and \
                   agent.topoStatusSysdbToP2pSm.topoIn in bti.values():
               # The SM already exists and its input still exists, so
               # do nothing.
               return
            # Find a TopoStatus instance that is not 'mlag', and
            # assume that the forwarding agent writes to it.
            hwTopoStatus = None
            for ( key, inst ) in bti.entityPtr.iteritems():
               if key != 'mlag' and inst and inst.tacType.fullTypeName == \
                    'Bridging::Topology::Inst::Status':
                  hwTopoStatus = inst
                  break
            if not agent.topoStatusSysdbToP2pSm:
               # We are becomes primary or secondary for the first
               # time. Assume that at least one non-mlag inst exists.
               assert hwTopoStatus, "Could not find TopoStatus that " \
                   "the forwarding agent writes to"
            # Destroy the old SM if it exists.
            agent.topoStatusSysdbToP2pSm = None
            # Export TopoPortStatus to my peer. 
            peerLinkIntf = ctx.status.peerLinkIntf
            assert peerLinkIntf
            agent.topoStatusSysdbToP2pSm = (
               hwTopoStatus, peerLinkIntf, lbts, agent.mlagStatus,
               ctx.protoStatus )
         # React to changes to the collection of
         # Bridging::Topology::Inst::Status entities.
         reactors.add( GenericReactor( bti, ['entityPtr'],
                                       handleTopoInst, callBackNow=True ) )

      if activeSupervisor() and not agent.topoStatusP2pToSysdbSm \
             and ctx.mountStatus.peerRoot:
         # Import TopoPortStatus from my peer.
         peerRootBridging = None
         # subdirDeprecated collection is being deprecated from EOS.
         # to be compatible with past/future releases 
         # first look up in default collection ( entityPtr )
         # see message on top of this file regarding subdirDeprecated
         # lookup/creation.
         if ctx.mountStatus.peerRoot.get( 'bridging' ):
            peerRootBridging = ctx.mountStatus.peerRoot['bridging']
         else:
            # lookup in subdirDeprecated collection
            peerRootBridging = ctx.mountStatus.peerRoot.subdirDeprecated['bridging']

         topologySubdir = None
         # subdirDeprecated collection is being deprecated from EOS.
         # to be compatible with past/future releases 
         # first look up in default collection ( entityPtr )
         # see message on top of this file regarding subdirDeprecated
         # lookup/creation.
         if peerRootBridging.get( 'topology' ):
            topologySubdir = peerRootBridging['topology']
         else:
            # lookup in subdirDeprecated collection
            topologySubdir = peerRootBridging.subdirDeprecated['topology']

         pbts = topologySubdir.entity['status']
         agent.topoStatusP2pToSysdbSm = (
            pbts, btc, btis, agent.mlagStatus, ctx.protoStatus )

   def handleInactive( btis ):
      reactors.clear()
      agent.topoStatusSysdbToP2pSm = None
      agent.topoStatusP2pToSysdbSm = None
      agent.doTopoStatusCleanupP2p( lbts )
      if activeSupervisor():
         agent.doTopoStatusCleanupSysdb( btis )

   def finishMounts():
      t2( "Mounts complete" )
      def handleMlagStateForTopo( mlagState, failover ):
         t2( "mlagState:", mlagState )
         if mlagState in ("primary", "secondary"):
            handleActive( mlagState, failover, btis )
         else:
            handleInactive( btis )
      ctx.callbackIs( handleMlagStateForTopo )

   mg.close( finishMounts )
