#!/usr/bin/env python
# Copyright (c) 2009-2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import Tracing, BothTrace
t0 = Tracing.trace0
t2 = Tracing.trace2
bt8 = BothTrace.trace8 # Maintenance Mode Traces
import Cell
import SharedMem
import Smash
import MlagMountHelper
import Errdisable
from MlagShared import CALLBACK_HIGH_PRIORITY

# subdirDeprecated collection is being deprecated from EOS.
# To be compatible with past/future releases, follow these
# recommendations:
# Do not introduce any new calls to newSubdirDeprecated
# i.e call newEntity to create an entity
# rather than a subdir.
# If looking up a subdir, first look in entityPtr collection
# if the key is not found, look in subdirDeprecated collection
# See AID/7616 for more details

def Plugin( ctx ):
   agent = ctx.agent

   # subdirDeprecated collection is being deprecated from EOS.
   # do not introduce new calls to newSubdirDeprecated,
   # use newEntity to create an entity instead.
   # see message on top of this file regarding subdirDeprecated
   # lookup/creation.
   # Writes to /ar/mlag/local/lag/*
   lagDir = ctx.localDir.newSubdirDeprecated( 'lag' )
   lacpDir = lagDir.newEntity( 'MlagP2p::Lacp::LacpDir', 'lacp' )
   p2pLagConfig = lagDir.newEntity( 'MlagP2p::Lag::Config', 'config' )
   p2pLagInputStatus = lagDir.newEntity( 'MlagP2p::Lag::Status', 'status' )
   intfStatus = lagDir.newSubdirDeprecated( 'input' ) \
      .newSubdirDeprecated( 'interface' )
   lagLagIntfStatus = intfStatus.newEntity(
      'MlagP2p::Lag::EthLagIntfStatusDir', 'lag' )

   # Reads from:
   mg = ctx.entityManager.mountGroup()
   # Mount mlag/config, Mlag::Config and its dependent paths
   mlagCfg = MlagMountHelper.mountMlagConfig( mg )
   # Mount mlag/status, Mlag::Status and its dependent paths
   mlagStatus = MlagMountHelper.mountMlagStatus( mg )
   mlagProtoStatus = mg.mount( 'mlag/proto', 'Mlag::ProtoStatus' )
   brConfig = mg.mount( 'bridging/config', 'Bridging::Config' )
   allIntfStatus = mg.mount( 'interface/status/all',
                             'Interface::AllIntfStatusDir' )
   allIntfStatusLocal = mg.mount( Cell.path( 'interface/status/local' ),
                                  'Interface::AllIntfStatusLocalDir' )

   lagConfig = mg.mount( 'lag/config', 'Lag::Config' )
   mg.mount( 'lag/input/config/cli', 'Lag::Input::Config', 'r' )
   mg.mount( 'interface/config/eth/lag', 'Interface::EthLagIntfConfigDir', 'r' )
   lagIntf = mg.mount( 'interface/config/eth/lag',
                       'Interface::EthLagIntfConfigDir' )
   lacpStatus = mg.mount( 'lag/lacp/status', 'Lacp::LacpStatus' )
   ethPeerIntfStatusDir = mg.mount( 'interface/status/eth/peer',
                                    'Interface::PeerIntfStatusDir' )
   lagInputStatusLag = mg.mount( 'lag/input/lagphyintfstatus', 'Lag::Input::Status' )
   inputIntfLag = mg.mount( 'lag/input/interface/lag',
                            'Lag::Input::EthLagIntfStatusDir', 'r' )
   localPeerIntfStatusDir = mg.mount( 'mlag/temp/peerintfstatus',
                                      'Interface::PeerIntfStatusDir', 'w' )

   # Writes to:
   mlagInputDevnameDir = mg.mount( 'lag/input/devname/mlag',
                                   'Lag::Input::IntfDeviceNameDir', 'wc' )
   lacpOverrideDir = mg.mount( 'lag/input/lacpoverride/mlag',
                               'Lag::Input::LacpOverrideDir', 'wc' )
   maintModeCause = mg.mount( 'interface/errdisable/cause/mlagmaintdown',
                              'Errdisable::CauseStatus', 'wc' )

   shmemEm = SharedMem.entityManager( sysdbEm=ctx.entityManager )
   inputMlagLagSI = Smash.mountInfo( 'writer', [ ( 'intfStatus', 2000 ) ] )
   inputMlagLag = shmemEm.doMount( 'lag/input/mlag/lag', 
         'Smash::Lag::EthLagIntfStatusOverrideDir', inputMlagLagSI )
   inputMlagPhySI = Smash.mountInfo( 'writer', [ ( 'intfStatus', 2000 ) ] )
   inputMlagPhy = shmemEm.doMount( 'lag/input/mlag/phy', 
         'Smash::Lag::EthPhyIntfStatusDir', inputMlagPhySI )
   inputMlagPeerSI = Smash.mountInfo( 'writer', [ ( 'intfStatus', 2000 ) ] )
   inputMlagPeer = shmemEm.doMount( 'lag/input/mlag/peer', 
         'Smash::Lag::PeerIntfStatusDir', inputMlagPeerSI )
   lagInputIntfMlag = Tac.newInstance( 'Lag::Input::EthLagIntfStatusDir', '' )
   lagInputIntfMlagSysdb = mg.mount( 'lag/input/interface/mlag', 
                                     'Lag::Input::EthLagIntfStatusDir', 'r' )

   inputLagLagSI = Smash.mountInfo( 'shadow' )
   inputLagLag = shmemEm.doMount( "lag/input/lag/lag", 
         "Smash::Lag::EthLagIntfStatusDir", inputLagLagSI )
   inputLagPhySI = Smash.mountInfo( 'shadow' )
   inputLagPhy = shmemEm.doMount( "lag/input/lag/phy", 
         "Smash::Lag::EthPhyIntfStatusDir", inputLagPhySI )
   inputLagPeerSI = Smash.mountInfo( 'shadow' )
   inputLagPeer = shmemEm.doMount( "lag/input/lag/peer", 
         "Smash::Lag::PeerIntfStatusDir", inputLagPeerSI )

   agent.ethLagIntfStatusDir = \
         Tac.newInstance( "Smash::Lag::Agent::EthIntfStatusDir", "" )
   agent.mlagDeviceNames = \
         Tac.newInstance( "Mlag::Agent::MlagDeviceNames", "")

   lagInputConfigMlag = mg.mount( 'lag/input/config/mlag', 
                                  'Lag::Input::Config', 'wc' )
   lagInputStatusMlag = mg.mount( 'lag/input/status/mlag',
                                  'Lag::Input::Status', 'wc' )

   localDirLagSubdir = None
   # subdirDeprecated collection is being deprecated from EOS.
   # to be compatible with past/future releases 
   # first look up in default collection ( entityPtr )
   # see message on top of this file regarding subdirDeprecated
   # lookup/creation.
   if ctx.localDir.get( 'lag' ):
      localDirLagSubdir = ctx.localDir['lag']
   else:
      # lookup in subdirDeprecated collection
      localDirLagSubdir = ctx.localDir.subdirDeprecated['lag']

   localLagLacp = localDirLagSubdir['lacp']
   bootConfig = mg.mount( Cell.path( 'stageInput/boot/Mlag' ),
                          'Stage::AgentConfig', 'r' )
   bootStatus = mg.mount( Cell.path( 'stageAgentStatus/boot/Mlag' ),
                          'Stage::AgentStatus', 'w' )
   asuStatus = mg.mount( 'asu/hardware/status', 'Asu::AsuStatus', 'r' )
   portIdDir = mg.mount( 'interface/eth/portid', 'Interface::EthIntfPortIdDir', 'r' )

   def peerRoot():
      return ctx.mountStatus.peerRoot

   def activeSupervisor():
      return ctx.agent.runMode == 'mlagActive'      

   def handleActive( mlagState, failover ):
      if agent.lacpSyncSysdbToP2pSm:
         # Already primary or secondary
         if mlagState == 'primary':
            if agent.lacpSyncP2pToSysdbSm:
               t2( "Failover changed. Update peer state." )
               agent.lacpSyncP2pToSysdbSm.handleFailover( failover )
               agent.lagP2pToSysdbSm.handleFailover( failover )
      else:
         # Sync LACP and LAG state to my peer.
         agent.lacpSyncSysdbToP2pSm = (
            agent.mlagStatus, lacpStatus, lacpDir )

         lagPhyIntfMapping = Tac.newInstance( "Lag::LagPhyIntfMapping", 
                                              "lagPhyIntfMapping" )
         agent.lagPhyIntfMappingSm = ( lagConfig, lagPhyIntfMapping )

         agent.lagSysdbToP2pSm = (
            mlagCfg, mlagStatus, mlagProtoStatus, agent.mlagStatus, 
            lagPhyIntfMapping, lagConfig,
            p2pLagConfig, agent.ethLagIntfStatusDir, lagLagIntfStatus,
            lagInputStatusLag, p2pLagInputStatus, agent.tapPamManager.tapPams,
            allIntfStatus, allIntfStatusLocal, agent.kniRoot.kniStatus,
            agent.mlagDeviceNames )

      if not activeSupervisor() or agent.lacpSyncP2pToSysdbSm or not peerRoot():
         return

      # Decide what LACP port ID range I will use.
      # If the peer has already chosen a range, we will choose
      # the other half. If the peer hasn't decided, then we will
      # use the bridgeMac address to decide the range. This preserves
      # the lagId on the surviving peer when mlag is reformed and prevent
      # lacp from re-negotiating.
      portNumberMax = Tac.Value( 'Lacp::PortNumber', 0 ).max
      portIdBoundary = ( portNumberMax + 1 ) >> 1 # Half of the range
      hasLowerMac = brConfig.bridgeMacAddr < peerRoot()['mlag'].nodeMacAddress

      portIdOffsetMap = { 'lacpPortIdOffsetLow' : ( 0, portIdBoundary ),
                          'lacpPortIdOffsetHigh' : 
                          ( portIdBoundary, portNumberMax ) }
      portIdOffsetToggle = { 'lacpPortIdOffsetLow' : 'lacpPortIdOffsetHigh',
                             'lacpPortIdOffsetHigh' : 'lacpPortIdOffsetLow' }

      lagSubdir = None
      # subdirDeprecated collection is being deprecated from EOS.
      # to be compatible with past/future releases 
      # first look up in default collection ( entityPtr )
      # see message on top of this file regarding subdirDeprecated
      # lookup/creation.
      if peerRoot().get( 'lag' ):
         lagSubdir = peerRoot()['lag']
      else:
         # lookup in subdirDeprecated collection
         lagSubdir = peerRoot().subdirDeprecated['lag']

      peerPortIdOffset = lagSubdir['lacp'].lacpPortIdOffset 
      localPortIdOffset = localLagLacp.lacpPortIdOffset
      if peerPortIdOffset == localPortIdOffset == 'lacpPortIdOffsetUnknown':
         if hasLowerMac:
            localLagLacp.lacpPortIdOffset = 'lacpPortIdOffsetLow'
         else:
            localLagLacp.lacpPortIdOffset = 'lacpPortIdOffsetHigh'
      elif peerPortIdOffset != 'lacpPortIdOffsetUnknown':
         assert peerPortIdOffset != localPortIdOffset
         if localPortIdOffset == 'lacpPortIdOffsetUnknown':
            localLagLacp.lacpPortIdOffset = \
                  portIdOffsetToggle[ peerPortIdOffset ]
      ( portIdOffset, portIdMax ) = \
            portIdOffsetMap[ localLagLacp.lacpPortIdOffset ]

      matchRequired = False \
            if localLagLacp.lacpPortIdOffset == 'lacpPortIdOffsetLow' \
            else True

      # Sync LACP and LAG state from my peer.
      agent.lacpSyncP2pToSysdbSm = ( agent.mlagStatus,
                                     lagSubdir.entity['lacp'],
                                     lacpOverrideDir, matchRequired )
      mlagP2pPhyIntfMapping = Tac.newInstance( "Mlag::Agent::MlagP2pPhyIntfMapping",
                                               "mlagP2pPhyIntfMapping" )
      peerP2pLagConfig = lagSubdir.entity['config']

      lagSubdirInput = None
      # subdirDeprecated collection is being deprecated from EOS.
      # to be compatible with past/future releases 
      # first look up in default collection ( entityPtr )
      # see message on top of this file regarding subdirDeprecated
      # lookup/creation.
      if lagSubdir.get( 'input' ):
         lagSubdirInput = lagSubdir['input']
      else:
         # lookup in subdirDeprecated collection
         lagSubdirInput = lagSubdir.subdirDeprecated['input']

      lagSubdirInputIntf = None
      # subdirDeprecated collection is being deprecated from EOS.
      # to be compatible with past/future releases 
      # first look up in default collection ( entityPtr )
      # see message on top of this file regarding subdirDeprecated
      # lookup/creation.
      if lagSubdirInput.get( 'interface' ):
         lagSubdirInputIntf = lagSubdirInput['interface']
      else:
         # lookup in subdirDeprecated collection
         lagSubdirInputIntf = lagSubdirInput.subdirDeprecated['interface']

      agent.mlagP2pPhyIntfMappingSm = ( peerP2pLagConfig, mlagP2pPhyIntfMapping )
      agent.lagP2pToSysdbSm = (
         mlagCfg, mlagStatus, mlagProtoStatus, agent.mlagStatus,
         mlagP2pPhyIntfMapping,lacpOverrideDir,
         portIdOffset, portIdMax, lagIntf, peerP2pLagConfig, lagInputConfigMlag,
         lagSubdirInputIntf.entity['lag'],
         ethPeerIntfStatusDir, lagInputIntfMlag,
         lagSubdir.entity['status'], lagInputStatusMlag,
         agent.agentImpl, agent.ethLagIntfStatusDir,
         agent.mlagDeviceNames,
         allIntfStatus, mlagInputDevnameDir, asuStatus, bootConfig, bootStatus,
         portIdDir )

   def handleInactive():
      localLagLacp.lacpPortIdOffset = 'lacpPortIdOffsetUnknown'
      agent.lagPhyIntfMappingSm = None
      agent.mlagP2pPhyIntfMappingSm = None
      agent.lagSysdbToP2pSm = None
      agent.lagP2pToSysdbSm = None
      agent.lacpSyncSysdbToP2pSm = None
      agent.lacpSyncP2pToSysdbSm = None
      agent.doLagP2pCleanup( lagLagIntfStatus, p2pLagInputStatus, p2pLagConfig )
      agent.doLacpP2pRemoteLagIdCleanup( lacpDir )
      if activeSupervisor():
         agent.doLagSysdbCleanup( mlagInputDevnameDir, lacpOverrideDir,
                                  lagInputIntfMlag,lagInputStatusMlag,
                                  lagInputConfigMlag )
         agent.doLacpRemoteLagIdCleanup( lacpOverrideDir )

   def eisoWriterSmIs():
      if activeSupervisor():
         agent.eisoWriterSm = ( lagInputIntfMlag, False,
                                inputMlagLag, inputMlagPhy, inputMlagPeer,
                                localPeerIntfStatusDir ) 
      else:
         # Stream the mlag input interface status update on active to the
         # standby smash table
         agent.eisoWriterSm = ( lagInputIntfMlagSysdb, True,
                                inputMlagLag, inputMlagPhy, inputMlagPeer,
                                localPeerIntfStatusDir )

   def finishMounts():
      t2( "Mounts complete" )

      if activeSupervisor():
         # Mlag LACP input override dir has a lower priority than the default
         # priority (10 - currently used for CLI input override dir).
         lacpOverrideDir.priority = lacpOverrideDir.priorityDefault - 5

         # Allow mlag device names to override forwarding agent device names.
         mlagInputDevnameDir.priority = mlagInputDevnameDir.priorityDefault + 10

      agent.eisReaderSm = ( inputLagLag, inputLagPhy, inputLagPeer, 
                            agent.ethLagIntfStatusDir, localPeerIntfStatusDir ) 
      eisoWriterSmIs()

      def createErrdisableEntity():
         em = ctx.entityManager
         mlagPoShutCauseDesc = "An MLAG peer switch was recently put under " \
                               "maintenance mode, and is temporarily shutting " \
                               "down all MLAG port channels."
         Errdisable.ErrdisableCauseGroupInit( em, 'mlagmaintdown', False,
               mlagPoShutCauseDesc, installCauseRecoveryCliCmd=False,
               syslogEnabled=False, enabledStateReason='maint-down' )


      def handleMlagStateForLag( mlagState, failover ):
         eisoWriterSmIs()
         if mlagState in ( 'primary', 'secondary' ):
            handleActive( mlagState, failover )
         else:
            handleInactive()

      # This is the helper function which is called by Mlag agent during
      # Maintenance Mode Linkdown Stage while entering maintenance.
      # It shuts down all the mlag port channels by adding them into the
      # errdisabled interfaces list in the cause group 'mlagmaintdown'.
      # A callback for this function is registered for the Agent to use.
      def handleMaintEnterLinkDown():
         bt8( "handleMaintEnterLinkDown: maintMode Errdisable Mlag Port channels" )
         maintModeErrdisableIntfs = set( [] )

         for mlagIntf, mlagIntfStatus in mlagStatus.intfStatus.items():
            bt8( "handleMaintEnterLinkDown:", mlagIntf, mlagIntfStatus.status )
            lagIntf = inputIntfLag.intfStatus.get( mlagIntf, None )
            bt8( "handleMaintEnterLinkDown:", mlagIntf, ": lagIntf:", lagIntf )
            if lagIntf:
               maintModeCause.newIntfStatus( lagIntf.intfId, Tac.now() )
               maintModeErrdisableIntfs.add( lagIntf.intfId )
               bt8( "handleMaintEnterLinkDown: maintMode Errdisable of",
                    lagIntf, "for", mlagIntf )

         # In case a restart happens, clear the stale errdisabled interfaces from
         # the cause status directory.
         for intf in maintModeCause.intfStatus:
            if intf not in maintModeErrdisableIntfs:
               bt8( "handleMaintEnterLinkDown: clearing errdisable of", intf )
               del maintModeCause.intfStatus[ intf ]

      # This is the helper function which is called by Mlag agent during
      # Maintenance Mode Linkdown Stage while exiting maintenance.
      # It brings back up all the mlag port channels which were configured earlier
      # by clearing up the cause group directory 'mlagmaintdown'.
      # A callback for this function is registered for the Agent to use.
      def handleMaintExitLinkDown():
         bt8( "handleMaintExitLinkDown: maintMode unshut Mlag port channels" )
         # Unshut the interfaces present in the errdisable interfaces list by
         # clear the cause status directory for the cause 'mlagmaintdown'.
         maintModeCause.intfStatus.clear()

      createErrdisableEntity()
      ctx.callbackIs( handleMlagStateForLag )
      ctx.linkDownEnterCallbackIs( handleMaintEnterLinkDown,
                                   priority=CALLBACK_HIGH_PRIORITY )
      ctx.linkDownExitCallbackIs( handleMaintExitLinkDown,
                                  priority=CALLBACK_HIGH_PRIORITY )
      # set lagPluginInitialized to True, to notify Mlag agent so that, it can
      # process any maintenance stages if needed.
      ctx.agent.pluginStatus.lagPluginInitialized = True

   mg.close( finishMounts )
