#!/usr/bin/env python
# Copyright (c) 2009-2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This MlagPlugin handles creating and destroying the reactors that
# manage the IgmpSnooping::Status objects.

import Tac
import Tracing
t0 = Tracing.trace0
t2 = Tracing.trace2

# subdirDeprecated collection is being deprecated from EOS.
# To be compatible with past/future releases, follow these
# recommendations:
# Do not introduce any new calls to newSubdirDeprecated
# i.e call newEntity to create an entity
# rather than a subdir.
# If looking up a subdir, first look in entityPtr collection
# if the key is not found, look in subdirDeprecated collection
# See AID/7616 for more details

def Plugin( ctx ):
   agent = ctx.agent
   
   # Writes to /ar/mlag/local/igmpsnooping/*
   # Create the Entities in /ar/mlag/local that will be sent to the peer
   # subdirDeprecated collection is being deprecated from EOS.
   # do not introduce new calls to newSubdirDeprecated,
   # use newEntity to create an entity instead.
   # see message on top of this file regarding subdirDeprecated
   # lookup/creation.
   igmpsnoopingDir = ctx.localDir.newSubdirDeprecated( 'igmpsnooping' )
   p2pLocal = igmpsnoopingDir.newEntity( "MlagP2p::IgmpSnooping::Status", 
                                     "status" )
   
   # Mount from sysdb.
   mg = ctx.entityManager.mountGroup()

   #This is the forwarding status that is specifically
   #written for Mlag.
   snoopingStatus = mg.mount( 'bridging/igmpsnooping/advertised/status', 
                   'Bridging::IgmpSnooping::SyncStatus', 'r' )
   igmpProtocolStatus = mg.mount( 'bridging/igmpsnooping/protocol/status',
                   'Bridging::IgmpSnooping::IgmpProtocolStatus', 'r' ) 

   toSysdb =  mg.mount( 'bridging/igmpsnooping/input/mlag',
                   'Bridging::IgmpSnooping::SyncStatus', 'wc' )
   # Writes to:
   def peerRoot():
      return ctx.mountStatus.peerRoot

   def mlagVersion():
      return ctx.protoStatus.mlagVersion

   def activeSupervisor():
      return ctx.agent.runMode == 'mlagActive'

   def handleActive( mlagState, failover ):
      if not activeSupervisor() or not peerRoot():
         t2( activeSupervisor(), " ", peerRoot() )
         return

      if agent.igmpSnoopingSysdbToP2pSm:
         # Already primary or secondary
         if mlagState == 'primary' and agent.igmpSnoopingP2pToSysdbSm:
            t2( "Failover changed. Update peer state." )
            agent.igmpSnoopingP2pToSysdbSm.handleFailover( failover )
      else:
         # Sync igmp snooping state to my peer.
         peerLinkIntf = ctx.status.peerLinkIntf
         assert peerLinkIntf
         t2( "Creating igmpSnoopingSysdbToP2pSm" )
         agent.igmpSnoopingSysdbToP2pSm = ( peerLinkIntf,
                                            snoopingStatus,
                                            igmpProtocolStatus,
                                            p2pLocal )

      if activeSupervisor() and not agent.igmpSnoopingP2pToSysdbSm \
             and peerRoot():
         # Import Igmp Snooping Vlan Status from my peer.
         igmpSnoopingPath = None
         # subdirDeprecated collection is being deprecated from EOS.
         # to be compatible with past/future releases
         # first look up in default collection ( entityPtr )
         # see message on top of this file regarding subdirDeprecated
         # lookup/creation.
         if peerRoot().get( 'igmpsnooping' ):
            igmpSnoopingPath = peerRoot()[ 'igmpsnooping' ]
         else:
         # lookup in subdirDeprecated collection
            igmpSnoopingPath = peerRoot().subdirDeprecated.get( 'igmpsnooping' )

         if igmpSnoopingPath is None or igmpSnoopingPath.get( 'status' ) is None:
            t2( "'igmpsnooping/status' path not present on peer" )
            return

         t2( "Creating igmpSnoopingP2pToSysdbSm" )
         p2pPeer = igmpSnoopingPath.entity[ 'status' ]
         mlagStatus = agent.mlagStatus
         agent.igmpSnoopingP2pToSysdbSm = ( p2pPeer, toSysdb, mlagStatus, 
               igmpProtocolStatus ) 
            
      return

   def handleInactive():
      
      t2( "Deleting SysdbToP2pSm and P2pToSysdbSm" )
      agent.igmpSnoopingSysdbToP2pSm = None
      agent.igmpSnoopingP2pToSysdbSm = None


      t2( "Cleaning up p2pLocal state" )
      agent.doIgmpSnoopingCleanupP2p( p2pLocal )

      if activeSupervisor():
         t2( "cleaning up old sysdb state" )
         agent.doIgmpSnoopingCleanupSysdb( toSysdb )
                                    

   def finishMounts():
      t2( "Mounts complete" )

      def handleMlagStateForIgmpSnooping( mlagState, failover ):
         t2( "mlagState:", mlagState )
         if mlagState in ( 'primary', 'secondary' ) and mlagVersion() >= 7 :
            handleActive( mlagState, failover )
         else:
            handleInactive()
      ctx.callbackIs( handleMlagStateForIgmpSnooping )

   mg.close( finishMounts )   
