# #!/usr/bin/env python
# # Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# # Arista Networks, Inc. Confidential and Proprietary.

import MlagMountHelper
from MlagShared import configCheckDir as CCD
import Tracing
t2 = Tracing.trace2

# subdirDeprecated collection is being deprecated from EOS.
# To be compatible with past/future releases, follow these
# recommendations:
# Do not introduce any new calls to newSubdirDeprecated
# i.e call newEntity to create an entity
# rather than a subdir.
# If looking up a subdir, first look in entityPtr collection
# if the key is not found, look in subdirDeprecated collection
# See AID/7616 for more details

def Plugin( ctx ):
   # Create local directories to be shared with peer.
   # subdirDeprecated collection is being deprecated from EOS.
   # do not introduce new calls to newSubdirDeprecated,
   # use newEntity to create an entity instead.
   # see message on top of this file regarding subdirDeprecated
   # lookup/creation.
   mlagDir = ctx.configCheckP2pDir.newSubdirDeprecated( 'mlag' )
   p2pMlagConfig = mlagDir.newEntity( "MlagP2p::ConfigCheck::GenericConfig",
                                      "config" )
   smContainer = ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::SmContainer',
                                               'MlagConfigCheckSm')
   # Mount from sysdb.
   mg = ctx.entityManager.mountGroup()
   # Mount mlag/config, Mlag::Config and its dependent paths
   mlagInputConfig = MlagMountHelper.mountMlagConfig( mg )
   configCheckDesc = \
       ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::ConfigCheckDesc',
                                     'Mlag')
   configCheckDesc.attrName['heartbeatInterval' ] = 'heartbeat-interval'
   configCheckDesc.attrName['reloadDelay' ] = 'reload-delay'
   configCheckDesc.attrName[ 'reloadDelayNonMlag' ] = 'reload-delay non-mlag'
   configCheckDesc.attrName[ 'lacpStandby' ] = 'reload-delay lacp mode'
   configCheckDesc.attrName['dualPrimaryDetectionDelay' ] = \
                            'dual-primary-detection-delay'
   configCheckDesc.attrName['dualPrimaryAction' ] = \
                            'dual-primary-action'
   configCheckDesc.attrName['peerMacRoutingEnabled' ] = \
                            'peer-mac-routing-enabled'
   configCheckDesc.attrName[ 'heartbeatPeerAddressConfigured' ] = \
                            'heartbeat-peer-address-configured'
   configCheckDesc.attrName[ 'dualPrimaryMlagRecoveryDelay' ] = \
                            'dual-primary-mlag-recovery-delay'
   configCheckDesc.attrName[ 'dualPrimaryNonMlagRecoveryDelay' ] = \
                            'dual-primary-non-mlag-recovery-delay'
   def peerRoot():
      return ctx.mountStatus.peerRoot

   def activeSupervisor():
      return ctx.agent.runMode == 'mlagActive'

   def handleActive( mlagState, failover ):
      if activeSupervisor() and peerRoot():
         try:
            configCheckDir = CCD( peerRoot() )
            mlagConfigDir = None
            # subdirDeprecated collection is being deprecated from EOS.
            # to be compatible with past/future releases 
            # first look up in default collection ( entityPtr )
            # see message on top of this file regarding subdirDeprecated
            # lookup/creation.
            if configCheckDir.get( 'mlag' ):
               mlagConfigDir = configCheckDir['mlag']
            else:
               # lookup in subdirDeprecated collection
               mlagConfigDir = configCheckDir.subdirDeprecated['mlag']
            peerMlagConfig = mlagConfigDir.entity['config']
         except KeyError:
            # This is an ISSU case. We will not have a configChecker for Mlag.
            return
         if smContainer.configCheckSm:
            if mlagState == 'primary':
               if failover:
                  smContainer.configCheckSm = None
                  ctx.configCheckPluginDel( "mlag" )
         else:
            configCheck = ctx.configCheckPlugin( "mlag" )
            smContainer.configCheckSm = ( configCheck, 'Mlag', 
                                          mlagInputConfig, p2pMlagConfig,
                                          peerMlagConfig, configCheckDesc, 
                                          mlagInputConfig )

   def handleInactive():
      t2( "handle mlag state Inactive in MlagConfigCheck" )
      smContainer.configCheckSm = None
      if activeSupervisor():
         ctx.configCheckPluginDel( "mlag" )

   def finishMounts():
      t2( "Mounts complete" )
      def handleMlagStateForMlagConfigCheck( mlagState, failover ):
         t2( "mlagState:", mlagState )

         if mlagState in ("primary", "secondary"):
            handleActive( mlagState, failover )
         else:
            handleInactive()
      ctx.callbackIs( handleMlagStateForMlagConfigCheck )

   mg.close( finishMounts )
