# #!/usr/bin/env python
# # Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# # Arista Networks, Inc. Confidential and Proprietary.
import MlagMountHelper
from MlagShared import configCheckDir as CCD
import BothTrace

bv = BothTrace.Var
bt2 = BothTrace.trace2

# subdirDeprecated collection is being deprecated from EOS.
# To be compatible with past/future releases, follow these
# recommendations:
# Do not introduce any new calls to newSubdirDeprecated
# i.e call newEntity to create an entity
# rather than a subdir.
# If looking up a subdir, first look in entityPtr collection
# if the key is not found, look in subdirDeprecated collection
# See AID/7616 for more details

def Plugin( ctx ):
   # Create local directories to be shared with peer.
   # subdirDeprecated collection is being deprecated from EOS.
   # do not introduce new calls to newSubdirDeprecated,
   # use newEntity to create an entity instead.
   # see message on top of this file regarding subdirDeprecated
   # lookup/creation.
   lagDir = ctx.configCheckP2pDir.newSubdirDeprecated( 'lag' )
   p2pLagConfig = lagDir.newEntity( "MlagP2p::ConfigCheck::GenericConfig",
                                    "lagConfig" )
   p2pLacpConfig = lagDir.newEntity( "MlagP2p::ConfigCheck::GenericConfig",
                                    "lacpConfig" )
   p2pLacpOverrideConfig = lagDir.newEntity( "MlagP2p::ConfigCheck::GenericConfig",
                                             "lacpOverrideConfig" )
   lagSmContainer = ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::SmContainer',
                                                  'LagConfigCheckSm')
   lacpSmContainer = ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::SmContainer',
                                                   'LacpConfigCheckSm')
   lacpOverrideSmContainer = ctx.configCheckDir.newEntity(
         'Mlag::ConfigCheck::SmContainer', 'LacpOverrideConfigCheckSm' )
   # Mount from sysdb.
   mg = ctx.entityManager.mountGroup()
   lacpCliConfig = mg.mount( 'lag/lacp/input/config/cli',
                              'Lacp::CliConfig', 'r' )
   lagIntfConfigDir = mg.mount( 'interface/config/eth/lag',
                                'Interface::EthLagIntfConfigDir', 'r' )
   lacpOverrideDir = mg.mount( 'lag/input/lacpoverride/cli',
                               'Lag::Input::LacpOverrideDir', 'r' )

   # Mount mlag/config, Mlag::Config and its dependent paths
   mlagConfig = MlagMountHelper.mountMlagConfig( mg )
   lacpConfigCheckDesc = \
       ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::ConfigCheckDesc',
                                     'Lacp' )
   lacpConfigCheckDesc.attrName[ 'priority' ] = 'lacp system-priority'
   lacpConfigCheckDesc.attrName[ 'portIdRange' ] = 'lacp port-id range'

   lagIntfDirConfigCheckDesc = \
       ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::ConfigCheckDesc',
                                     'Lag' )
   lagIntfConfigCheckDesc = lagIntfDirConfigCheckDesc.newNestedConfigCheckDesc( \
      'intfConfig' )
   lagIntfConfigCheckDesc.mlagInterfacesOnly = True
   lagIntfConfigCheckDesc.attrName['fallback'] = 'lacp fallback'
   lagIntfConfigCheckDesc.valueStrOverride['fallbackNone'] = 'none'
   lagIntfConfigCheckDesc.valueStrOverride['fallbackStatic'] = 'static'
   lagIntfConfigCheckDesc.valueStrOverride['fallbackIndividual'] = 'individual'

   lagIntfConfigCheckDesc.attrName['mode'] = 'lag mode'
   lagIntfConfigCheckDesc.valueStrOverride['lagModeUnconfigured'] = 'unconfigured'
   lagIntfConfigCheckDesc.valueStrOverride['lagModeOn'] = 'on'
   lagIntfConfigCheckDesc.valueStrOverride['lagModeLacp'] = 'lacp'

   lacpOverrideConfigDirCheckDesc = \
       ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::ConfigCheckDesc',
                                     'LacpOverride' )
   lacpOverrideConfigDirCheckDesc.collectionName['systemId'] = \
         'system-id override'

   def peerRoot():
      return ctx.mountStatus.peerRoot
   def activeSupervisor():
      return ctx.agent.runMode == 'mlagActive'

   def handleActive( mlagState, failover ):
      if activeSupervisor() and peerRoot():
         try:
            configCheckDir = CCD( peerRoot() )
            configLagDir = None
            # subdirDeprecated collection is being deprecated from EOS.
            # to be compatible with past/future releases 
            # first look up in default collection ( entityPtr )
            # see message on top of this file regarding subdirDeprecated
            # lookup/creation.
            if configCheckDir.get( 'lag' ):
               configLagDir = configCheckDir['lag']
            else:
               # lookup in subdirDeprecated collection
               configLagDir = configCheckDir.subdirDeprecated['lag']

            peerLagConfig = configLagDir.entity['lagConfig']
            peerLacpConfig = configLagDir.entity['lacpConfig']
            peerLacpOverrideConfig = configLagDir.entity[ 'lacpOverrideConfig' ]
         except KeyError:
            bt2( "Skipping configChecker for Lag due to ISSU incompatibility" )
            return

         if mlagState == 'primary' and failover:
            bt2( "failover. cleaning up Lag's configCheck state/sm" )
            lagConfigCheckCleanup()
            return

         bt2( "Starting configChecker for Lag" )
         lagConfigCheck = ctx.configCheckPlugin( "lag" )
         lacpConfigCheck = ctx.configCheckPlugin( "lacp" )
         lacpOverrideConfigCheck = ctx.configCheckPlugin( "lacpOverride" )
         # pluginName is different from feature name for lacp
         lacpConfigCheck.pluginName = "lag"
         lacpOverrideConfigCheck.pluginName = "lag" 
         lacpSmContainer.configCheckSm = ( lacpConfigCheck, 'Lacp',
                                       lacpCliConfig, p2pLacpConfig,
                                       peerLacpConfig, lacpConfigCheckDesc,
                                       mlagConfig )
         lagSmContainer.configCheckSm = ( lagConfigCheck, 'Lag',
                                          lagIntfConfigDir, p2pLagConfig,
                                          peerLagConfig,
                                          lagIntfDirConfigCheckDesc,
                                          mlagConfig )
         lacpOverrideSmContainer.configCheckSm = ( 
                                          lacpOverrideConfigCheck,
                                          'LacpOverride',
                                          lacpOverrideDir,
                                          p2pLacpOverrideConfig,
                                          peerLacpOverrideConfig, 
                                          lacpOverrideConfigDirCheckDesc,
                                          mlagConfig )

   def handleInactive():
      bt2( "handle mlag state Inactive in LagConfigCheck" )
      lagConfigCheckCleanup()

   def lagConfigCheckCleanup():
      lacpSmContainer.configCheckSm = None
      lagSmContainer.configCheckSm = None
      lacpOverrideSmContainer.configCheckSm = None
      if activeSupervisor():
         ctx.configCheckPluginDel( "lacpOverride" )
         ctx.configCheckPluginDel( "lacp" )
         ctx.configCheckPluginDel( "lag" )

   def finishMounts():
      bt2( "Mounts complete" )
      def handleMlagStateForLagConfigCheck( mlagState, failover ):
         bt2( "mlagState:", bv( mlagState ) )

         if mlagState in ("primary", "secondary"):
            handleActive( mlagState, failover )
         else:
            handleInactive()
      ctx.callbackIs( handleMlagStateForLagConfigCheck )

   mg.close( finishMounts )

