#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# This MlagPlugin handles creating and destroying the reactors that
# observe dhcp relay configuration changes on the mlag peers.

import Tracing
import MlagMountHelper
from MlagShared import configCheckDir as CCD
t2 = Tracing.trace2

# subdirDeprecated collection is being deprecated from EOS.
# To be compatible with past/future releases, follow these
# recommendations:
# Do not introduce any new calls to newSubdirDeprecated
# i.e call newEntity to create an entity
# rather than a subdir.
# If looking up a subdir, first look in entityPtr collection
# if the key is not found, look in subdirDeprecated collection
# See AID/7616 for more details

def Plugin( ctx ):
   # Create local directories to be shared with peer.
   # subdirDeprecated collection is being deprecated from EOS.
   # do not introduce new calls to newSubdirDeprecated,
   # use newEntity to create an entity instead.
   # see message on top of this file regarding subdirDeprecated
   # lookup/creation.
   dhcpRelayDir = ctx.configCheckP2pDir.newSubdirDeprecated( 'dhcpRelay' )
   p2pDhcpRelayConfig = dhcpRelayDir.newEntity( 
                                        "MlagP2p::ConfigCheck::GenericConfig",
                                        "dhcpRelayConfig" )

   dhcpRelaySmContainer = ctx.configCheckDir.newEntity( 
                                             'Mlag::ConfigCheck::SmContainer',
                                             'DhcprelayConfigCheckSm' )
   dhcpRelayConfigCheckDesc = \
       ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::ConfigCheckDesc',
                                     'DhcpRelay' )
   dhcpRelayConfigEntT = \
       dhcpRelayConfigCheckDesc.newNestedConfigCheckDesc( 'intfConfig' )
   dhcpRelayConfigEntT.absenceImpliesDefaultVal = True
   dhcpRelayConfigEntT.attrName['route6Install'] = 'dhcpv6-route-install'
   dhcpRelayConfigEntT.defaultVal['route6Install'] = 'False'

   # Mount from sysdb.
   mg = ctx.entityManager.mountGroup()
   dhcpRelayConfig = mg.mount( "ip/helper/dhcprelay/config", 
                          'Ip::Helper::DhcpRelay::Config', 'r' )
   # Mount mlag/config, Mlag::Config and its dependent paths
   mlagConfig = MlagMountHelper.mountMlagConfig( mg )
   def peerRoot():
      return ctx.mountStatus.peerRoot

   def activeSupervisor():
      return ctx.agent.runMode == 'mlagActive'

   def handleActive( mlagState, failover ):
      t2( "handle mlag state Active in DhcpRelayConfigCheck" )
      if activeSupervisor() and peerRoot():
         try:
            peerRootConfigCheck = CCD( peerRoot() )
            # subdirDeprecated collection is being deprecated from EOS.
            # to be compatible with past/future releases
            # first look up in default collection ( entityPtr )
            # see message on top of this file regarding subdirDeprecated
            # lookup/creation.
            if peerRootConfigCheck.get( 'dhcpRelay' ):
               peerDhcpRelayConfig = peerRootConfigCheck[ 'dhcpRelay' ]. \
                     entity[ 'dhcpRelayConfig' ]
            else:
            # lookup in subdirDeprecated collection
               peerDhcpRelayConfig = peerRootConfigCheck.\
                     subdirDeprecated[ 'dhcpRelay' ].entity[ 'dhcpRelayConfig' ]
         except KeyError:
            # This is an ISSU case. We will not have a configChecker for DhcpRelay.
            return
         if dhcpRelaySmContainer.configCheckSm:
            if mlagState == 'primary':
               if failover:
                  dhcpRelaySmContainer.configCheckSm = None
                  ctx.configCheckPluginDel( "dhcpRelay" )
         else:
            dhcpRelayConfigCheck = ctx.configCheckPlugin( "dhcpRelay" )
            dhcpRelaySmContainer.configCheckSm = ( dhcpRelayConfigCheck, 'DhcpRelay',
                                               dhcpRelayConfig, p2pDhcpRelayConfig, 
                                               peerDhcpRelayConfig,
                                               dhcpRelayConfigCheckDesc, mlagConfig )

   def handleInactive():
      t2( "handle mlag state Inactive in DhcpRelayConfigCheck" )
      dhcpRelaySmContainer.configCheckSm = None
      if activeSupervisor():
         ctx.configCheckPluginDel( "dhcpRelay" )

   def finishMounts():
      t2( "Mounts complete" )
      def handleMlagStateForDhcpRelayConfigCheck( mlagState, failover ):
         t2( "mlagState:", mlagState )
         if mlagState in ("primary", "secondary"):
            handleActive( mlagState, failover )
         else:
            handleInactive()
      ctx.callbackIs( handleMlagStateForDhcpRelayConfigCheck )

   mg.close( finishMounts )
