#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import MlagMountHelper
from MlagShared import configCheckDir as CCD
import Tracing
t2 = Tracing.trace2

# subdirDeprecated collection is being deprecated from EOS.
# To be compatible with past/future releases, follow these
# recommendations:
# Do not introduce any new calls to newSubdirDeprecated
# i.e call newEntity to create an entity
# rather than a subdir.
# If looking up a subdir, first look in entityPtr collection
# if the key is not found, look in subdirDeprecated collection
# See AID/7616 for more details

def Plugin( ctx ):
   # Create local directories to be shared with peer.
   # subdirDeprecated collection is being deprecated from EOS.
   # do not introduce new calls to newSubdirDeprecated,
   # use newEntity to create an entity instead.
   # see message on top of this file regarding subdirDeprecated
   # lookup/creation.
   bridgingDir = ctx.configCheckP2pDir.newSubdirDeprecated( 'bridging' )
   p2pBridgingConfig = bridgingDir.newEntity( "MlagP2p::ConfigCheck::GenericConfig",
                                               "config" )
   smContainer = ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::SmContainer',
                                                 'BridgingConfigCheckSm')
   # Mount from sysdb.
   mg = ctx.entityManager.mountGroup()
   bridgingInputConfig = mg.mount( 'bridging/input/config/cli',
                              'Bridging::Input::CliConfig', 'r')
   # Mount mlag/config, Mlag::Config and its dependent paths
   mlagConfig = MlagMountHelper.mountMlagConfig( mg )
   configCheckDesc = \
       ctx.configCheckDir.newEntity( 'Mlag::ConfigCheck::ConfigCheckDesc',
                                       'Bridging')

   vlanConfigEntT = configCheckDesc.newNestedConfigCheckDesc('vlanConfig')
   vlanConfigEntT.attrName['adminState'] = 'admin-state vlan'
   vlanConfigEntT.attrName[ 'macLearning' ] = 'mac-learning vlan'
   vlanConfigEntT.collectionName['trunkGroup'] = 'trunk-group vlan'

   switchIntfConfigEntT = \
       configCheckDesc.newNestedConfigCheckDesc('switchIntfConfig')
   switchIntfConfigEntT.mlagInterfacesOnly = True
   switchIntfConfigEntT.absenceImpliesDefaultVal = True
   switchIntfConfigEntT.attrName['switchportMode'] = 'switchport-mode'
   switchIntfConfigEntT.attrName[ 'macLearningEnabled' ] = 'switchport mac learning'
   switchIntfConfigEntT.attrName['accessVlan'] = 'access-vlan'
   switchIntfConfigEntT.attrName['trunkNativeVlan'] = 'trunk-native-vlan'
   switchIntfConfigEntT.attrName['trunkAllowedVlans'] = 'trunk-allowed vlan'
   # provide default values for the interface ( since absenceImpliesDefaultVal )
   switchIntfConfigEntT.defaultVal['switchportMode'] = '\'access\''
   switchIntfConfigEntT.defaultVal[ 'macLearningEnabled' ] = 'True'
   switchIntfConfigEntT.defaultVal['accessVlan'] = '1'
   switchIntfConfigEntT.defaultVal['trunkNativeVlan'] = '1'
   switchIntfConfigEntT.defaultVal['trunkAllowedVlans'] = '\'1-4094\''

   switchIntfConfigEntT.collectionName['trunkGroup'] = 'trunk-group'

   def peerRoot():
      return ctx.mountStatus.peerRoot

   def activeSupervisor():
      return ctx.agent.runMode == 'mlagActive'

   def handleActive( mlagState, failover ):
      if activeSupervisor() and peerRoot():
         try:
            configCheckDir = CCD( peerRoot() )
            bridgingDir = None
            # subdirDeprecated collection is being deprecated from EOS.
            # to be compatible with past/future releases 
            # first look up in default collection ( entityPtr )
            # see message on top of this file regarding subdirDeprecated
            # lookup/creation.
            if configCheckDir.get( 'bridging' ):
               bridgingDir = configCheckDir['bridging']
            else:
               # lookup in subdirDeprecated collection
               bridgingDir = configCheckDir.subdirDeprecated['bridging']
            peerBridgingConfig = bridgingDir.entity[ 'config' ]
         except KeyError:
            # This is an ISSU case. We will not have a configChecker for Bridging.
            return
         if smContainer.configCheckSm:
            if mlagState == 'primary':
               if failover:
                  smContainer.configCheckSm = None
                  ctx.configCheckPluginDel( "bridging" )
         else:
            configCheck = ctx.configCheckPlugin( "bridging" )
            smContainer.configCheckSm = ( configCheck, 'Bridging',
                                          bridgingInputConfig, p2pBridgingConfig,
                                          peerBridgingConfig, configCheckDesc,
                                          mlagConfig )

   def handleInactive():
      t2( "handle mlag state Inactive in BridgingConfigCheck" )
      smContainer.configCheckSm = None
      if activeSupervisor():
         ctx.configCheckPluginDel( "bridging" )
         
   def finishMounts():
      t2( "Mounts complete" )
      def handleMlagStateForBridgingConfigCheck( mlagState, failover ):
         t2( "mlagState:", mlagState )

         if mlagState in ("primary", "secondary"):
            handleActive( mlagState, failover )
         else:
            handleInactive()
      ctx.callbackIs( handleMlagStateForBridgingConfigCheck )

   mg.close( finishMounts )

