#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from IpLibConsts import DEFAULT_VRF
from Arnet import IpGenAddr

mirroringConfigSysdbPath = 'mirroring/config'
mirroringHwCapabilitySysdbPath = 'mirroring/hwcapability'

MetadataElementType = Tac.Type( 'Mirroring::MetadataElementType' )
GreTunnelKey = Tac.Type( "Mirroring::GreTunnelKey" )

def OperStateType():
   return Tac.Type( "Mirroring::OperState" )

tokenMetadataElementDict = {
   'ingress-vlan' : MetadataElementType.ingressVlan,
   'egress-port'  : MetadataElementType.egressPort,
   'ingress-port' : MetadataElementType.ingressPort
}

metadataElementTokenDict = {
   MetadataElementType.ingressVlan : 'ingress-vlan',
   MetadataElementType.egressPort  : 'egress-port',
   MetadataElementType.ingressPort : 'ingress-port',
}

def createGreTunnelKey( srcIp, destIp, ttl, dscp,
                        greHdrProto=GreTunnelKey.defaultGreHdrProto,
                        forwardingDrop=False, vrf=DEFAULT_VRF ):
   assert isinstance( srcIp, str ) == isinstance( destIp, str )
   if isinstance( srcIp, str ):
      return GreTunnelKey( IpGenAddr( srcIp ), IpGenAddr( destIp ), ttl, dscp,
                           greHdrProto, forwardingDrop, vrf )
   else:
      return GreTunnelKey( srcIp, destIp, ttl, dscp, greHdrProto, forwardingDrop,
                           vrf )

def createV4ZeroGreTunnelKey():
   return createGreTunnelKey( '0.0.0.0', '0.0.0.0', 0, 0, 0 )

def createV6ZeroGreTunnelKey():
   return createGreTunnelKey( '::', '::', 0, 0, 0 )

