# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from Ark import ReversibleDict

# Cli cipher to Tac cipher suite
cliToTacCipherSuite = ReversibleDict ( { 
   "aes128-gcm-xpn" : 'gcmAesXpn128',
   "aes256-gcm-xpn" : 'gcmAesXpn256',
   "aes128-gcm" : 'gcmAes128',
   "aes256-gcm" : 'gcmAes256'
} )

# Tac cipher suite to cli cipher
tacCipherSuiteToCli = cliToTacCipherSuite.reverse()

trafficPolicyOnNoMkaToCli = ReversibleDict( {
   'useActiveSak' : 'allow active-sak',
   'unprotected' : 'allow',
   'blocked' : 'drop'
} )

cliToTrafficPolicyOnNoMka = trafficPolicyOnNoMkaToCli.reverse()

intfTrafficStatus = ReversibleDict ( {
   'Protected' : 'encrypted',
   'Unprotected' : 'unencrypted',
   'None' : 'blocked'
} )

def trafficStatus( cpStatus ):
   if not cpStatus.controlledPortEnabled:
      return "trafficBlocked"
   else:      
      if cpStatus.unprotectedTraffic:
         return "trafficUnprotected"
      else:
         return "trafficProtected"
