# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import random

minLoopbackIntfNum = 0
maxLoopbackIntfNum = 2100

def randomLoopbackIndex( ):
   '''
   Returns a single random loopback index within the allowed range. It will be
   the min index 1/3 of the time, the max index 1/3 of the time, or a random
   middle index 1/3 of the time.
   '''
   randomMiddle = random.randrange( minLoopbackIntfNum + 1, maxLoopbackIntfNum )
   return random.choice( [ minLoopbackIntfNum, maxLoopbackIntfNum, randomMiddle ] )

def randomLoopbackIndexes( n ):
   '''
   Returns a list of n unique random loopback indexes within the allowed range.
   '''
   if n < 1:
      return []
   loopbackRange = xrange( minLoopbackIntfNum, maxLoopbackIntfNum + 1 )
   return random.sample( loopbackRange, n )

def randomLoopbackName( ):
   '''
   Returns a random loopback interface name within the allowed range.
   '''
   return 'Loopback%i' % randomLoopbackIndex()
