# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division

import Tac

ChassisIdentifier = Tac.Type( "Lldp::ChassisIdentifier" )
PortIdentifier = Tac.Type( "Lldp::PortIdentifier" )
PortStatus = Tac.Type( "Lldp::PortStatus" )
Msap = Tac.Type( "Lldp::RemoteSystem::Msap" )
RemoteSystem = Tac.Type( "Lldp::RemoteSystem" )

BoundedString32Tlv = Tac.Type( "Lldp::BoundedString32Tlv" )
BoundedString255Tlv = Tac.Type( "Lldp::BoundedString255Tlv" )
SystemCapabilitiesTlv = Tac.Type( "Lldp::SystemCapabilitiesTlv" )
ManagementAddressKey = Tac.Type( "Lldp::ManagementAddress::Key" )
ManagementAddress = Tac.Type( "Lldp::ManagementAddress" )
ManAddrPriority = Tac.Type( "Lldp::ManAddrPriority" )
UnknownTlv = Tac.Type( "Lldp::UnknownTlv" )
UnknownOrgDefTlvKey = Tac.Type( "Lldp::UnknownOrgDefTlv::Key" )
UnknownOrgDefTlv = Tac.Type( "Lldp::UnknownOrgDefTlv" )

VlanName = Tac.Type( "Lldp::VlanName" )
PortAndProtocolVlan = Tac.Type( "Lldp::PortAndProtocolVlan" )
ProtocolIdentityInfo = Tac.Type( "Lldp::ProtocolIdentityInfo" )

MacPhyConfigStatusInfo = Tac.Type( "Lldp::MacPhyConfigStatusInfo" )
LinkAggregationInfo = Tac.Type( "Lldp::LinkAggregationInfo" )
MaximumFrameSizeInfo = Tac.Type( "Lldp::MaximumFrameSizeInfo" )

ExternalTlvPortConfigKey = Tac.Type( "Lldp::ExternalTlvPortConfig::Key" )
MgmtAddrTxOption = Tac.Type( "Lldp::MgmtAddrTxOption" )

SystemCapabilitiesMap = Tac.Type( "Lldp::SystemCapabilitiesMap" )
PortConfig = Tac.Type( "Lldp::PortConfig" )
EnabledTlvs = Tac.Type( "Lldp::PortConfig::EnabledTlvs" )
Dot3EnabledTlvs = Tac.Type( "Lldp::PortConfig::Dot3EnabledTlvs" )
TiaEnabledTlvs = Tac.Type( "Lldp::PortConfig::TiaEnabledTlvs" )
LinkAggStatusMap = Tac.Type( "Lldp::LinkAggStatusMap" )

LocalPortPoeInfo = Tac.Type( "Lldp::LocalPortPoeInfo" )
MedCapabilitiesInfo = Tac.Type( "Lldp::MedCapabilitiesInfo" )
Capability = Tac.Type( "Lldp::MedCapabilitiesInfo::Capability" )
MedDeviceType = Tac.Type( "Lldp::MedCapabilitiesInfo::MedDeviceType" )
Watts = Tac.Type( "Units::Watts" )

PowerViaMdiInfo = Tac.Type( "Lldp::PowerViaMdiInfo" )
PowerViaMdiInfo_IeeeStandard = Tac.Type( "Lldp::PowerViaMdiInfo::IeeeStandard" )
PowerViaMdiInfo_At = Tac.Type( "Lldp::PowerViaMdiInfo::At" )
PowerViaMdiInfo_Bt = Tac.Type( "Lldp::PowerViaMdiInfo::Bt" )
PowerViaMdiInfo_PdPoweredStatus = Tac.Type(
                                    "Lldp::PowerViaMdiInfo::Bt::PdPoweredStatus" )
PowerViaMdiInfo_PowerClassExt = Tac.Type(
                                    "Lldp::PowerViaMdiInfo::Bt::PowerClassExt" )

NetworkPolicyConfig = Tac.Type( 'Lldp::NetworkPolicyConfig' ) 
NetworkPolicyTlv = Tac.Type( 'Lldp::NetworkPolicyTlv' )

LocationIdTlv = Tac.Type( 'Lldp::LocationId' )
CoordinateBasedLCI = Tac.Type( 'Lldp::LocationId::CoordinateBasedLCI' )
EcsElin = Tac.Type( 'Lldp::LocationId::EcsElin' )
CivicAddressLCI = Tac.Type( "Lldp::LocationId::CivicAddressLCI" )
CivicAddressLCI_Element = Tac.Type( "Lldp::LocationId::CivicAddressLCI::CaElement" )
