# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, LldpLib, DcbxLib
from DcbxTypes import PriorityFlowControlConfigInfo, applicationPriorityEntry

def parsePfcConfigTlv( tlv ):
   if len( tlv.orgDefInfo ) != 2:
      raise LldpLib.MalformedTlvError(
            "Priority Flow Control Config TLV has invalid length" )
   pfcci = PriorityFlowControlConfigInfo()
   pfcci.willing = bool( ord( tlv.orgDefInfo[ 0 ] ) & 0x80 )
   pfcci.macSecBypassCapability = bool( ord( tlv.orgDefInfo[ 0 ] ) & 0x40 )
   pfcci.pfcCapability = ord( tlv.orgDefInfo[ 0 ] ) & 7
   if pfcci.pfcCapability == 0:
      pfcci.pfcCapability = 8
   pfcci.pfcEnable = ord( tlv.orgDefInfo[ 1 ] )
   return DcbxLib.priorityFlowControlConfigInfoStr( pfcci )

def parseAppPrioConfigTlv( tlv ):
   apci = Tac.newInstance( "Dcbx::ApplicationPriorityConfigInfo", "tmp" )
   if ( ( len( tlv.orgDefInfo ) - 1 ) % 3 ) != 0:
      raise LldpLib.MalformedTlvError(
            "Application Priority Config TLV has invalid length" )

   i = 1
   while i < len( tlv.orgDefInfo ):
      sel = ord( tlv.orgDefInfo[ i ] ) & 7
      protocolId = \
            ( ord( tlv.orgDefInfo[ i + 1 ] ) << 8 ) | \
            ord( tlv.orgDefInfo[ i + 2 ] )
      priority = ord( tlv.orgDefInfo[ i ] ) >> 5
      apci.addApplicationPriorityEntry(
            applicationPriorityEntry( priority, sel, protocolId ) )
      i += 3

   return DcbxLib.applicationPriorityConfigInfoStr( apci )

def hexLines( data, prefix='', rowLen=16 ):
   lines = []
   while data:
      lines.append( prefix +
            ' '.join( [ '%02x' % ord( c ) for c in data[ :rowLen ] ] ) )
      data = data[ rowLen: ]
   return lines

#def parsePreStandardDcbx( tlv ):
#   data = tlv.orgDefInfo
#   lines = [ "Pre-standard DCB Capability Exchange Protocol:" ]
#   # lines += hexLines( data, prefix='# ' )
#   while len( data ) > 6:
#      type = ord( data[ 0 ] ) >> 1
#      typeStr = { 1: "DCBX Control",
#                  2: "Priority Groups",
#                  3: "Priority Flow Control",
#                  4: "Application Protocol",
#                  5: "Application",
#                  6: "Logical Link Down",
#                  7: "Network Interface Virtualization" }.get( type, "Unknown" )
#      length = ( ( ord( data[ 0 ] ) & 1 ) << 8 ) | ord( data[ 1 ] )
#      lines.append( "- type: %s (%d), length: %d" % ( typeStr, type, length ) )
#      operVersion = ord( data[ 2 ] )
#      maxVersion = ord( data[ 3 ] )
#      lines.append(
#            "  operVersion=%d, maxVersion=%d" % ( operVersion, maxVersion ) )
#
#      if typeStr == "DCBX Control" and operVersion == 0:
#         seqNo, ackNo = struct.unpack( "!II", data[ 4 : 12 ] )
#         lines.append( "  seqNo=0x%x, ackNo=0x%x" % ( seqNo, ackNo ) )
#
#      else:
#         enable = bool( ord( data[ 4 ] ) & 0x80 )
#         willing = bool( ord( data[ 4 ] ) & 0x40 )
#         error = bool( ord( data[ 4 ] ) & 0x20 )
#         subType = ord( data[ 5 ] )
#         lines.append( "  enable: %d, willing: %d, error: %d, subtype: %d" % (
#                     enable, willing, error, subType ) )
#
##         if typeStr == "Priority Groups" and operVersion == 0:
#         lines += hexLines( data[ 6 : 2 + length ], prefix='  ' )
#
#      data = data[ 2 + length : ]
#
#   if len( data ) != 0:
#      raise LldpLib.MalformedTlvError(
#            "Traffic Classes Supported TLV has invalid length" )
#
#   return lines

def Plugin( _arg ):
   LldpLib.registerUnknownOrgDefTlvStrFn(
         0x80c2, 11, parsePfcConfigTlv )
   LldpLib.registerUnknownOrgDefTlvStrFn(
         0x80c2, 12, parseAppPrioConfigTlv )

#   LldpLib.registerUnknownOrgDefTlvStrFn(
#         0x1b21, 1, parsePreStandardDcbx )
