# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division

import Tracing
t3 = Tracing.trace3

_unknownOrgDefTlvStrFns = {}

class MalformedTlvError( ValueError ):
   pass

def registerUnknownOrgDefTlvStrFn( oui, subtype, function ):
   t3( "register", function, "for", oui, subtype )
   _unknownOrgDefTlvStrFns[ oui, subtype ] = function

def unknownOrgDefTlvStrFn( unknownOrgDefTlv ):
   t3( "look for", unknownOrgDefTlv.key.oui, unknownOrgDefTlv.key.subtype )
   return _unknownOrgDefTlvStrFns.get( 
         ( unknownOrgDefTlv.key.oui, unknownOrgDefTlv.key.subtype ) )
