# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division

import re

defaultAdminStatus = 'txAndRx'

tlvKeywordToAttrNameMap = {
   'port-description' : 'portDescTlvEnabled',
   'system-name' : 'sysNameTlvEnabled',
   'system-description' : 'sysDescTlvEnabled',
   'system-capabilities' : 'sysCapTlvEnabled',
   'management-address' : 'mgmtAddrTlvEnabled',
   'port-vlan' : 'portVlanIdTlvEnabled',
   'link-aggregation' : 'linkAggregationTlvEnabled',
   'max-frame-size' : 'maxFrameSizeTlvEnabled',
   'power-via-mdi' : 'powerViaMdiTlvEnabled',
}

medTlvKeywordToAttrNameMap = {
   'network-policy' : 'medNetworkPolicyTlvEnabled',
}

chassisIdSubtypeValues = {
   'cidReserved' : 0,
   'cidChassisComponent' : 1,
   'cidInterfaceAlias' : 2,
   'cidPortComponent' : 3,
   'cidMacAddress' : 4,
   'cidNetworkAddress' : 5,
   'cidInterfaceName' : 6,
   'cidLocal' : 7,
   'cidUnknown' : 8,
}

def chassisIdSubtypeToValue( subtype ):
   value = chassisIdSubtypeValues.get( subtype )
   if value is None:
      m = re.match( r'Lldp::ChassisIdSubtype\((\d+)\)$', subtype )
      value = int( m.group( 1 ) )
   assert 0 <= value <= 255
   return value

portIdSubtypeValues = {
   'pidReserved' : 0,
   'pidInterfaceAlias' : 1,
   'pidPortComponent' : 2,
   'pidMacAddress' : 3,
   'pidNetworkAddress' : 4,
   'pidInterfaceName' : 5,
   'pidAgentCircuitId': 6,
   'pidLocal' : 7,
   'pidUnknown' : 8,
}

def portIdSubtypeToValue( subtype ):
   value = portIdSubtypeValues.get( subtype )
   if value is None:
      m = re.match( r'Lldp::PortIdSubtype\((\d+)\)$', subtype )
      value = int( m.group( 1 ) )
   assert 0 <= value <= 255
   return value

ifSubtypeValues = {
   'unknown' : 1,
   'ifIndex' : 2,
   'systemPortNumber' : 3,
}

def ifSubtypeToValue( subtype ):
   value = ifSubtypeValues.get( subtype )
   if value is None:
      m = re.match( r'Lldp::ManAddrIfSubtype\((\d+)\)$', subtype )
      value = int( m.group( 1 ) )
   return value

