# Copyright (c) 2006, 2007 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""Utility functions for userspace access to legacy device resources.

This module provides utility functions for direct read and write access to system
memory and I/O ports.
"""

import Pci

def ioRead8( addr ):
   return Pci.PseudoMmapResource( "/dev/port", readOnly=True ).read8( addr )

def ioRead32( addr ):
   return Pci.PseudoMmapResource( "/dev/port", readOnly=True ).read32( addr )

def ioWrite8( addr, value ):
   Pci.PseudoMmapResource( "/dev/port" ).write8( addr, value )

def ioWrite32( addr, value ):
   Pci.PseudoMmapResource( "/dev/port" ).write32( addr, value )

def memRead8( addr ):
   return Pci.PseudoMmapResource( "/dev/mem", readOnly=True ).read8( addr )

def memRead32( addr ):
   return Pci.PseudoMmapResource( "/dev/mem", readOnly=True ).read32( addr )

def memWrite8( addr, value ):
   Pci.PseudoMmapResource( "/dev/mem" ).write8( addr, value )

def memWrite32( addr, value ):
   Pci.PseudoMmapResource( "/dev/mem" ).write32( addr, value )
