#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ldap
from Arnet.NsLib import NamespaceType, setns

class RunInNetworkNamespace( object ):
   def __init__( self, nsName ):
      self.orig = open( '/proc/self/ns/net' )
      self.origFd = self.orig.fileno()
      self.nsName = nsName
      self.ns = open( '/var/run/netns/%s' % nsName )
      self.nsFd = self.ns.fileno()

   def __enter__( self ):
      try:
         setns( self.nsFd, nsType=NamespaceType.NETWORK )
      except Exception:
         # BUG378902, remove dependency on ldap. Need to correctly handle exceptions
         # in Ldap.py sendAuthenReq and sendAuthzReq and raise appropriate
         # AuthenticationError and AuthorizationError
         raise ldap.CONNECT_ERROR( "setns failed for VRF namespace" )

   def __exit__( self, exception, execType, stackTrace ):
      setns( self.origFd, nsType=NamespaceType.NETWORK )
