#!/usr/bin/python
# Copyright (c) 2010-2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: import LauncherPlugin.Launcher

def Plugin( context ):
   config = context.lookup( 'zerotouch/config' )
   status = context.lookup( 'zerotouch/status' )

   agentName = 'ZeroTouch'
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/' + agentName,
                'argv': [],
                'heartbeatPeriod': 30,
                'runnability': [ { 'entity' : config,
                                   'qualAttr' : 'enabled' },
                                 { 'entity' : status,
                                   'qualAttr' : 'enabled' } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
