#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   config = context.lookup( "mgmt/xmpp/config" )
   status = context.lookup( "mgmt/xmpp/status" )

   agentName = "Xmpp"
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/Xmpp",
                "argv" : [],
                "heartbeatPeriod" : 30,
                'runnability': [ { 'entity' : config,
                                   'qualAttr' : 'enabled' },
                                 { 'entity' : status,
                                   'qualAttr' : 'enabled' } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
