#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   vxlanConfigDir = context.lookup( 'vxlan/config' )
   vxlanStatusDir = context.lookup( 'vxlan/status' )
   fhrpVxRunnability = context.lookup( 'routing/fhrp/input/runnability/vxlan' )

   # Vxlan runs unconditionally on the active supervisor.
   agentName = "Vxlan"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/Vxlan",
                "argv": [],
                "heartbeatPeriod": 120,
                "runnability": [ { "entity": vxlanConfigDir,
                                   "qualAttr": "vxlanConfig" },
                                 { "entity": vxlanStatusDir,
                                   "qualAttr": "vxlanStatus" },
                                 # This is only used for cleanup. We should 
                                 # set the vxlanEnabled flag for Fhrp to false
                                 # before the Launcher kills the agent
                                 { "entity": fhrpVxRunnability,
                                   "qualAttr": "vxlanEnabled" } ]
                }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

   # Configure the VxlanSwFwd agent to run on the active supervisor when
   # the vxlan interface is configured.
   agentName = "VxlanSwFwd"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/VxlanSwFwd",
                "argv": [],
                "heartbeatPeriod": 120,
                "oomScoreAdj" : -350, #  see AID3426
                "runnability": [ { "entity": vxlanConfigDir,
                                   "qualAttr": "vxlanConfig" } ]
                }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
