#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher
import Cell

def Plugin( context ):

   vlConfig = context.lookup( 'routing/vrfleak/config' )

   # VrfLeak run logic is: ( haveConfig AND multiAgent ) OR dirty

   runnability = [ ( { 'qualPath' :
                       'cell/%cellId/routing/defaultVrfProtocolLaunch/IpRib' },
                     { 'entity' : vlConfig, 'qualAttr' : 'vrf' }, ),
                   { 'qualPath' : 'cell/%cellId/routing/vrfleak/dirty/dirty' } ]

   agentCfg = { 'name': 'VrfLeak',
                'exe': '/usr/bin/VrfLeak',
                'argv': [],
                'heartbeatPeriod': 30,
                'runnability' : runnability }

   roleName = context.allSupervisorsRoleName
   context.agentConfigIs( roleName, agentCfg )
