#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):

   roleName = context.activeSupervisorRoleName
   agentName = "VmTracer"
   agentCfg = { "name": agentName,
                "exe": "/usr/bin/VmTracer",
                "argv": [ '--sliceId=%(sliceId)s' ],
                "heartbeatPeriod": 250,
                "runnability": [ { "qualPath": "vmtracer/slice/enable/%sliceId" },
                                 { "qualPath": "vmtracer/slice/running/%sliceId" } ]
              }

   context.agentConfigIs( roleName, agentCfg )
