#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   agentName = "Vm"

   config = context.lookup( "vm/config" )
   status = context.lookup( "vm/status" )

   agentCfg = { "name": agentName,
                "exe": "/usr/bin/Vm",
                "argv": [],
                "heartbeatPeriod": 30,
                "runnability": [ { "entity": config,
                                   "qualAttr": 'vmConfig' },
                                 { "entity": status,
                                   "qualAttr": 'vmStatus' } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
