#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   agentName = 'TwampReflector'
   # Start TwampReflector when a session is configured, but only finish it after
   # that session status is removed by the agent.
   config = context.lookup( 'connectivityMonitor/twamp/reflector/config' )
   status = context.lookup( 'connectivityMonitor/twamp/reflector/status' )
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/TwampReflector',
                'argv': [],
                'heartbeatPeriod': 30,
                'runnability': [ { 'entity': config, 'qualAttr': 'sessionConfig' },
                                 { 'entity': status, 'qualAttr': 'sessionStatus' } ]
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
