#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
from __future__ import absolute_import, print_function, division

import LauncherPlugin.Launcher

def Plugin( context ):
   agentName = 'TwampControl'
   controlConfig = context.lookup( 'connectivityMonitor/twamp/control/config' )
   # Control agent will be started once the user invokes 'TWAMP server' in the CLI
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/TwampControl',
                'argv': [],
                'heartbeatPeriod': 30,
                'runnability': [ { 'entity': controlConfig,
                                   'qualAttr': 'enabled' } ]
   }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
