#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   tunnelIntfConfigDir = context.lookup( 'interface/config/tunnel/intf' )
   tunnelIntfStatusDir = context.lookup( 'interface/status/tunnel/intf' )
   routingHwStatus = context.lookup( 'routing/hardware/status' )

   tunIntfConfig = { 'entity' : tunnelIntfConfigDir,
                     'qualAttr' : 'intfConfig' }
   tunIntfStatus = { 'entity' : tunnelIntfStatusDir,
                     'qualAttr' : 'intfStatus' }
   runnabilitySupported = { 'entity' : routingHwStatus,
                            'qualAttr' : 'staticTunIntfPlatformCapabilityDeclared' }
   # runnability = ( runnabilitySupported and ( tunIntfConfig or
   #                 tunIntfStatus ) )
   agentCfg = { 'name': 'TunnelIntf',
                'exe': '/usr/bin/TunnelIntf',
                'argv': [],
                'heartbeatPeriod': 30,
                "oomScoreAdj" : -300, #  see AID3426
                'runnability': [ ( runnabilitySupported,
                               [ tunIntfConfig, tunIntfStatus ] ) ]
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
