#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   config = context.lookup( "te/segmentrouting/srtepolicy/staticconfig" )
   status = context.lookup( "te/segmentrouting/srtepolicy/status" )
   agentName = 'SrTePolicy'
   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/SrTePolicy',
                'argv': [],
                'runnability': [ { "entity": config,
                                   "qualAttr": "enabled", },
                                 { "entity": status,
                                   "qualAttr": "agentEnabled", } ],
                'heartbeatPeriod': 30 }
   roleName = { 'sso': context.allSupervisorsRoleName,
                'rpr': context.activeSupervisorRoleName }
   context.agentConfigIs( roleName, agentCfg )
