#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   # Run the agent on all the supervisors. This ensures that the
   # secondary supervisor has enough entropy to support ssh when
   # entropy is enabled. The agent running on the active supervisor
   # can access all the Sol chips in the switch. The agent running
   # on the secondary supervisor can only access the Sol chip on the
   # secondary supervisor card.

   agentName = "Sol"
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/" + agentName,
                "argv" : [],
                "heartbeatPeriod" : 60,
                "runnability" : [ {
                   "qualPath" : "hardware/sol/config/cell/%cellId.solConfig/%*"
                   } ]
              }

   agentRoleName = context.allSupervisorsRoleName
   context.agentConfigIs( agentRoleName, agentCfg )
