#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher
from ProcMgrLib import OOM_NONESSENTIAL_PROC

def Plugin( context ):
   config = context.lookup( 'snmp/config' )

   agentCfg = { 'name' : 'Snmp',
                'exe' : '/usr/bin/Snmp',
                'argv' : [],
                'heartbeatPeriod' : 60,
                'oomScoreAdj' : OOM_NONESSENTIAL_PROC, #  see AID3426
                'startupGracePeriod' : 600,     # see BUG48278
                'runnability': [ { 'entity' : config,
                                   'qualAttr' : 'serviceEnabled' } ] }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
