#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   agentName = "Sflow"

   # If Int agent is running, then sflow agent waits for the int
   # agent to shutdown. The int agent shutdown process is initiated
   # when sflow agent turns up and is marked as completed once "int"
   # entry is deleted from the activeAgent dir. Once this is done,
   # the "inbandTelemetry" qualpath check fails and sflow agent starts
   sflowConfig = context.lookup( "sflow/config" )
   sflowStatus = context.lookup( "sflow/status" )
   intLauncherPath = 'flowtracking/activeAgent/inbandTelemetry'
   postcardLauncherPath = 'postcardtelemetry/activeAgent/postcardTelemetry'

   agentCfg = { "name": agentName,
                "exe":"/usr/bin/Sflow",
                "argv": [],
                "heartbeatPeriod" : 30,
                "oomScoreAdj" : -100, #  see AID3426
                "runnability": (
                   { 'qualPath' : intLauncherPath,
                     'negate' : True },
                   { 'qualPath' : postcardLauncherPath,
                     'negate' : True },
                   [ { "entity" : sflowConfig,
                       "qualAttr" : "enabled" },
                     { "entity" : sflowStatus,
                       "qualAttr" : "active" } ]
                 )
              }

   roleName = context.allSupervisorsRoleName
   context.agentConfigIs( roleName, agentCfg )
