#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   agentName = "Sfe"
   launcherPath = 'hardware/sfe/launcherConfig/Sfe'
   routeCacheConfig = context.lookup( 'routecache/config' )
   routingHwStatus = context.lookup( 'routing/hardware/status' )
   openFlowStatus = context.lookup( 'openflow/status' )

   runnability = [
         # runnability is:
         # launcherPath present AND routingHwStatus.routeCacheSupported = False
         ( { 'qualPath' : launcherPath },
           { 'entity' : routingHwStatus, 'qualAttr' : 'routeCacheSupported',
              'negate' : True } ),
         # OR
         # launcherPath present AND routingHwStatus.routeCacheSupported AND \
         #     routeCacheConfig.cachingEnabled
         ( { 'qualPath' : launcherPath },
           { 'entity' : routingHwStatus, 'qualAttr' : 'routeCacheSupported' },
           { 'entity' : routeCacheConfig, 'qualAttr' : 'cachingEnabled' } ),
         # OR
         # openFlowStatus.softwareForwarding = True
         ( { 'entity' : openFlowStatus, 'qualAttr' : 'softwareForwarding' } )
         ]

   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/Sfe",
                "argv" : [],
                "heartbeatPeriod" : 180,
                "runnability" : runnability
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )

