#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   # SftAgent runs if
   # 1) Sflow Agent is not running/configured and
   # 2) flow-tracking is enabled and
   # 3) HwFlowTracking is disabled
   # 4) HwFlowTracking agent is not running.
   # 5) if int-agent is running, wait for its clean shutdown
   # (i.e. wait for "inbandTelemetry" qualPath check to fail)
   # or
   # Sft agent is running (during cleanup).

   sflowConfig = context.lookup( "sflow/config" )
   sflowStatus = context.lookup( "sflow/status" )
   sftConfig = context.lookup( 'flowtracking/config/sampled' )
   hwFtConfig = context.lookup( 'flowtracking/config/hardware' )
   sftLauncherPath = 'flowtracking/activeAgent/sft'
   hwFtLauncherPath = 'flowtracking/activeAgent/hwAccel'
   intLauncherPath = 'flowtracking/activeAgent/inbandTelemetry'
   postcardLauncherPath = 'postcardtelemetry/activeAgent/postcardTelemetry'
   agentName = 'SftAgent'
   runnability = [
         (
            { 'entity' : sflowConfig, 'qualAttr' : 'enabled', 'negate' : True },
            { 'entity' : sflowStatus, 'qualAttr' : 'active', 'negate' : True },
            { 'entity' : hwFtConfig, 'qualAttr' : 'enabled', 'negate' : True },
            { 'entity' : sftConfig, 'qualAttr' : 'enabled' },
            { 'qualPath' : hwFtLauncherPath, 'negate' : True },
            { 'qualPath' : intLauncherPath, 'negate' : True },
            { 'qualPath' : postcardLauncherPath, 'negate' : True },
         ),
         { 'qualPath' : sftLauncherPath },
         ]
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/SftAgent',
                'argv' : [],
                'heartbeatPeriod' : 90,
                'runnability' : runnability }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
