#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher
import os

def Plugin( context ):
   # Start Sai agent unconditionaly in a test environment if the
   # env var SAITEST is set, otherwise start based on config.enable
   if os.environ.get( 'SAITEST' ) is not None:
      agentCfg = { "name": "Sai",
                   "exe": "/usr/bin/Sai",
                   "argv": [],
                   "heartbeatPeriod": 0 }
   else:
      config = context.lookup( "sai/config" )
      agentCfg = { "name": "Sai",
                   "exe": "/usr/bin/Sai",
                   "argv": [],
                   "runnability": [ { "entity": config,
                                      "qualAttr": "enable" }, ],
                   "heartbeatPeriod": 0 }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
