#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Add explicit dependency on Launcher
# pkgdeps: import LauncherPlugin.Launcher
import Tac

def Plugin( context ):
   agentName = 'Rsvp'
   cliConfig = context.lookup( Tac.Type( "Rsvp::RsvpCliConfig" ).mountPath )
   shared = context.lookup( Tac.Type( "Rsvp::RsvpShared" ).mountPath )

   rsvpConfigured = { 'entity': cliConfig,
                      'qualAttr': 'enabled' }

   rsvpRunning = { 'entity': shared,
                   'qualAttr': 'agentRunnable',
                 }

   agentCfg = { 'name': agentName,
                'exe': '/usr/bin/Rsvp',
                'argv': [],
                'runnability': [ rsvpConfigured, rsvpRunning ],
                "oomScoreAdj": -300, # see AID3426
                'heartbeatPeriod': 30 }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
