#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pkgdeps:import LauncherPlugin.Launcher

def Plugin( context ):
   rpkiConfigDir = context.lookup( 'routing/rpki/cache/config' )
   rpkiStatusDir = context.lookup( 'routing/rpki/cache/status' )

   rpkiConfig = { 'entity': rpkiConfigDir,
                  'qualAttr': 'cacheConfig' }
   rpkiStatus = { 'entity': rpkiStatusDir,
                  'qualAttr': 'cacheStatus' }
   multiAgentMode = { 'qualPath':
                      'cell/%cellId/routing/defaultVrfProtocolLaunch/Bgp' }

   # runnability :  ( ( rpkiConfig AND multiAgentMode ) OR rpkiStatus )
   agentCfg = { 'name': 'Rpki',
                'exe': '/usr/bin/Rpki',
                'argv': [],
                'heartbeatPeriod': 30,
                'runnability': [ ( rpkiConfig, multiAgentMode ), rpkiStatus ]
              }

   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
