#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   agentName = 'RouteCache'
   routeCacheConfig = context.lookup( 'routecache/config' )
   routingHwStatus = context.lookup( 'routing/hardware/status' )
   runnability = [
      # runnability is:
      # ( routeCache supported OR
      #   routecache/config/cleanupRequired TRUE )
      { 'entity': routingHwStatus, 'qualAttr': 'routeCacheSupported' },
      { 'entity': routeCacheConfig, 'qualAttr': 'cleanupRequired' }
   ]
   agentCfg = { 'name': agentName,
                     'launchName': agentName,
                     'exe': '/usr/bin/RouteCache',
                     'argv': [],
                     'heartbeatPeriod': 180,
                     'runnability': runnability }

   roleName = context.activeSupervisorRoleName

   context.agentConfigIs( roleName, agentCfg )
