#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pkgeps : import LauncherPlugin.Launcher
from LauncherPlugin.Rib import registerAgent

def Plugin( context ):
   # Rip should run only when the device is in multi-agent mode
   runnability = ( { "qualPath":
                     "cell/%cellId/routing/defaultVrfProtocolLaunch/Rip" }, )

   # Register Main Rip ( BR )
   registerAgent( context, "Rip", runnability, [] )

   # Vrf Rip ( VR ) is always conditional on the existence of vrf status
   vrfRunnability = \
      ( { "qualPath": "cell/%cellId/routing/RipVrfLaunchIndicator/%sliceId" }, )
   argv = "--z", "'client name %(sliceId)s ns-name ns-%(sliceId)s " \
          "vrfname %(sliceId)s servername vre_server'", "--sliceId=%(sliceId)s"
   registerAgent( context, "Rip-vrf", vrfRunnability, argv,
                  exeName="/usr/bin/Rip-vrf" )
