# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   rcfConfig = context.lookup( "routing/rcf/config" )
   rcfStatus = context.lookup( "routing/rcf/status_ci" )

   agentCfg = { "name": "Rcf",
                "exe": "/usr/bin/Rcf",
                "argv": [],
                "heartbeatPeriod": 30,
                "startupGracePeriod": 150,
                # Tiny bit lower than agents that depends on us (Bgp is -300)
                "oomScoreAdj": -350,
                "runnability": [ { "entity": rcfConfig,
                                   "qualAttr": "enabled" },
                                 { "entity": rcfStatus,
                                   "qualAttr": "enabled" }, ]
              }
   roleName = context.allSupervisorsRoleName
   context.agentConfigIs( roleName, agentCfg )

