#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher
from ProcMgrLib import OOM_NONESSENTIAL_PROC

def Plugin( context ):
   fruConfig = context.lookup( 'ptpTimeSync/config' )
   ptpConfig = context.lookup( 'ptp/config' )
   qosStatus = context.lookup( 'qos/status' )
   mirroringStatus = context.lookup( 'mirroring/status' )
   timestampingStatus = context.lookup( 'interface/status/timestamping' )
   ptpTimeSyncConfig = context.lookup( 'ptpTimeSync/config' )
   ptpTimeSyncStatus = context.lookup( 'ptpTimeSync/status/global' )
   lanzLatencyStatus = context.lookup( 'hardware/lanz/latency' )

   ptpTimeSyncSupported = { 'entity' : fruConfig,
                            'qualAttr' : 'supported' }
   ptpConfigured = { 'entity' : ptpConfig,
                     'qualAttr' : 'ptpMode' }
   delayEcnEnabled = { 'entity' : qosStatus,
                       'qualAttr' : 'ecnDelayThreshold' }
   greTimestampingEnabled = { 'entity' : mirroringStatus,
                              'qualAttr' :'greTimestampingEnabled' }
   timestampingEnabled = { 'entity' : timestampingStatus,
                           'qualAttr' : 'numEnabled' }
   lanzEnabledOnSand = { 'entity' : lanzLatencyStatus,
                         'qualAttr' : 'enabled' }
   ptpTimeSyncAlwaysOn = { 'entity' : ptpTimeSyncConfig,
                           'qualAttr' : 'alwaysOn' },

   ptpTimeSyncNotDisabled = { 'entity' : ptpTimeSyncStatus,
                              'qualAttr' : 'state' }

   agentName = "PtpTimeSync"
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/PtpTimeSync',
                'argv' : [],
                'heartbeatPeriod' : 30,
                'oomScoreAdj' : -350, #  see AID3426
                'runnability' : ( ptpTimeSyncSupported,
                                  [ ptpConfigured,
                                    delayEcnEnabled,
                                    greTimestampingEnabled,
                                    timestampingEnabled,
                                    ptpTimeSyncAlwaysOn,
                                    ptpTimeSyncNotDisabled,
                                    lanzEnabledOnSand ] ) }
   role = { 'rpr' : context.activeSupervisorRoleName,
            'sso' : context.allSupervisorsRoleName }
   context.agentConfigIs( role, agentCfg )
