#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):

   #-------------------------------------------------------------------------
   # Ptp runs only on the active supervisor. This may need to change once
   # we have Ptp on modular.
   #-------------------------------------------------------------------------
   roleName = { 'sso' : context.allSupervisorsRoleName,
                'rpr' : context.activeSupervisorRoleName }
   ptpConfig = context.lookup( 'ptp/config' )
   ptpStatus = context.lookup( 'ptp/status' )

   def configureAgent( name, exe ):
      agentName = name
      agentCfg = { "name" : agentName,
                   "exe" : exe,
                   "argv" : [],
                   "heartbeatPeriod" : 30,
                   "oomScoreAdj" : -350, #  see AID3426
                   "runnability": [ { "entity" : ptpConfig,
                                      "qualAttr" : "enabled" },
                                    { "entity" : ptpStatus,
                                      "qualAttr" : "enabled" } ] }
      context.agentConfigIs( roleName, agentCfg )

   configureAgent( "Ptp", "/usr/bin/Ptp" )
