# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher
import Toggles.PostcardTelemetryCommonToggleLib as toggleLib

def Plugin( context ):
   if toggleLib.toggleFeaturePostcardTelemetryEnabled():
      # PostcardTelemetry agent runs if
      # 1) Sflow Agent is not running/configured and
      # 2) Inband Telemetry is disabled
      # 3) Sampled/Hardware flow-tracking is disabled
      # 4) Postcard Telemetry is enabled
      sflowConfig = context.lookup( "sflow/config" )
      sflowStatus = context.lookup( "sflow/status" )
      intConfig = context.lookup( 'inbandtelemetry/config' )
      sftConfig = context.lookup( 'flowtracking/config/sampled' )
      sftLauncherPath = 'flowtracking/activeAgent/sft'
      intLauncherPath = 'flowtracking/activeAgent/inbandTelemetry'

      postcardConfig = context.lookup( 'postcardtelemetry/policyconfig' )
      postcardLauncherPath = 'postcardtelemetry/activeAgent/postcardTelemetry'
      startupGracePeriod = 300
      runnability = [
         (
            { 'entity': sflowConfig, 'qualAttr': 'enabled', 'negate': True },
            { 'entity': sflowStatus, 'qualAttr': 'active', 'negate': True },
            { 'entity': intConfig, 'qualAttr': 'enable', 'negate': True },
            { 'entity': sftConfig, 'qualAttr': 'enabled', 'negate': True },
            { 'entity': postcardConfig, 'qualAttr': 'enable' },
            { 'qualPath': sftLauncherPath, 'negate': True },
            { 'qualPath': intLauncherPath, 'negate': True },
         ),
         { 'qualPath': postcardLauncherPath },
      ]

      agentCfg = { 'name': 'PostcardTelemetry',
                   'launchName': 'PostcardTelemetry',
                   'exe': '/usr/bin/PostcardTelemetry',
                   'argv': [],
                   'heartbeatPeriod': 30,
                   "startupGracePeriod": startupGracePeriod,
                   "runnability": runnability }

      roleName = context.activeSupervisorRoleName
      context.agentConfigIs( roleName, agentCfg )
