#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   portsecConfig = context.lookup( "portsec/config" )
   macFlapConfig = context.lookup( "macflap/config" )

   agentName = "PortSec"
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/PortSec",
                "argv" : [],
                "heartbeatPeriod" : 30,
                "oomScoreAdj" : -100, #  see AID3426
                "runnability": [ { "entity" : portsecConfig,
                                   "qualAttr" : "intfConfig" },
                                 { "entity" : macFlapConfig,
                                   "qualAttr" : "enabled" } ] }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
