#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   pmbusConfig = context.lookup( 'hardware/powerSupply/pmbus11' )
   pmbusStatus = context.lookup( 'hardware/powerSupply/status/pmbus11' )

   agentName = 'Pmbus'
   agentCfg = { 'name' : agentName,
                'exe' : '/usr/bin/Pmbus',
                'argv' : [],
                'heartbeatPeriod' : 30,
                'runnability' : [ { 'entity' : pmbusConfig,
                                    'qualAttr' : 'powerSupply' },
                                  { 'entity' : pmbusStatus,
                                    'qualAttr' : 'pmbusStatus' } ] }
   roleName = context.activeSupervisorRoleName
   context.agentConfigIs( roleName, agentCfg )
