#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher
import Toggles.ArbusToggleLib

def Plugin( context ):

   # PlxPcieAgent runs on a given cell when the Hardware::Scd for that cell exists
   # in "hardware/cell/<cellId>".

   switchConfigDir = \
      context.lookup( "hardware/pcieSwitch/config/cell/%d" %
                      Cell.cellId() )
   runnability = [
      {
         "entity" : switchConfigDir,
         "qualAttr" : "hasPlx"
      }
   ]
   agentCfg = { "name" : "PlxPcie",
                "exe" : "/usr/bin/PlxPcie",
                "argv" : [],
                "heartbeatPeriod" : 30,
                "runnability" : runnability }

   roleName = context.allCellsRoleName
   context.agentConfigIs( roleName, agentCfg )

   # Register the system version of the agent, this
   # controls plx switches which aren't tied to supervisors

   agentCfg = { "name" : "PlxPcie-system",
                "exe" : "/usr/bin/PlxPcie",
                "heartbeatPeriod" : 30 }

   if Toggles.ArbusToggleLib.toggleSlicePlxPcieEnabled():
      agentCfg[ "runnability" ] = [
         { "qualPath" :
           "hardware/pcieSwitch/config/launcher/plx/%sliceId"
         } ]
      agentCfg[ "argv" ] = [ "--system", "--sliceId=%(sliceId)s" ]
      agentCfg[ "launchName" ] = "PlxPcie"
   else:
      if Cell.cellType() == 'supervisor':
         agentCfg[ "runnability" ] = [
            { "qualPath" :
              "hardware/cell/%cellId/pciDeviceMap/config.pciDeviceConfig/%*"
            } ]
         agentCfg[ "argv" ] = [ "--system", "--sliceId=system" ]
      else:
         # On fixed systems, only run the agent if there are PLX switches to manage
         switchConfigDir = context.lookup( "hardware/pcieSwitch/config/system" )
         agentCfg[ "runnability" ] = [
            {
               "entity" : switchConfigDir,
               "qualAttr" : "hasPlx"
            }
         ]
         agentCfg[ "argv" ] = [ "--system", "--sliceId=system" ]

   context.agentConfigIs( roleName, agentCfg )
