#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   mcastAgentStatus = context.lookup( 'routing/multicast/agentstatus' )
   runnability = [ { 'entity' : mcastAgentStatus,
                     'qualAttr' : 'pimbsrEnabled' } ]

   # PimBsr runs unconditionally on the active supervisor.
   agentCfg = { "name": "PimBsr",
                "exe": "/usr/bin/PimBsr",
                "argv": [],
                "heartbeatPeriod": 30,
                "oomScoreAdj" : -50, #  see AID3426
                "runnability" : runnability }

   role = { 'rpr' : context.activeSupervisorRoleName,
            'sso' : context.allSupervisorsRoleName }

   context.agentConfigIs( role, agentCfg )
