#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):
   if Cell.cellType() == 'supervisor':
      runnability = [ { 'qualPath': "picasso/control/cell/%cellId.enabled/%*" } ]

      agentCfg = { "name": "Picasso",
                   "exe": "/usr/bin/Picasso",
                   "argv": [],
                   "heartbeatPeriod": 30,
                   "runnability" : runnability  }

      roleName = { 'rpr' : context.activeSupervisorRoleName,
                   'sso' : context.allSupervisorsRoleName }
      context.agentConfigIs( roleName, agentCfg )
