#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# Import used to generate dependency on Launcher
# pylint: disable=import-error
# pylint: disable=unused-import
import LauncherPlugin.Launcher

def Plugin( context ):

   # -------------------------------------------------------------------------
   # Set up the PhyEthtool agent's AgentConfig.
   #
   # PhyEthtool runs on a given cell when the
   # Hardware::Phy::EthtoolConfig for that cell exists in
   # "hardware/cell/<cellId>". This is achieved by setting the
   # "qualPath" to "hardware/cell/%cellId/phy/ethtool/config",
   # the path of the Hardware::Phy::EthtoolConfig object
   # for a given cell.
   # -------------------------------------------------------------------------
   agentName = "PhyEthtool"
   runnability = [ { "qualPath" :
                        "hardware/cell/%cellId/phy/ethtool/config.phy/%*" } ]
   agentCfg = { "name" : agentName,
                "exe" : "/usr/bin/PhyEthtool",
                "argv" : [],
                "heartbeatPeriod" : 30,
                "oomScoreAdj" : -250, #  see AID3426
                "runnability" : runnability }

   roleName = context.allCellsRoleName
   context.agentConfigIs( roleName, agentCfg )
